/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.elasticsearch.analysis.common.SynonymTokenFilterFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;

public class SynonymGraphTokenFilterFactory
extends SynonymTokenFilterFactory {
    SynonymGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings, SynonymsManagementAPIService synonymsManagementAPIService) {
        super(indexSettings, env, name, settings, synonymsManagementAPIService);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymGraphFactory to specialize this factory for an analysis chain first");
    }

    @Override
    public TokenFilterFactory getChainAwareTokenFilterFactory(IndexService.IndexCreationContext context, TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = SynonymGraphTokenFilterFactory.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters);
        final SynonymTokenFilterFactory.ReaderWithOrigin rulesFromSettings = this.getRulesFromSettings(this.environment, context);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, rulesFromSettings);
        final String name = this.name();
        return new TokenFilterFactory(){

            public String name() {
                return name;
            }

            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymGraphFilter(tokenStream, synonyms, false);
            }

            public AnalysisMode getAnalysisMode() {
                return SynonymGraphTokenFilterFactory.this.analysisMode;
            }

            public String getResourceName() {
                return rulesFromSettings.resource();
            }
        };
    }
}

