/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.bn.BengaliStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.ckb.SoraniStemFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanLightStemFilter;
import org.apache.lucene.analysis.de.GermanMinimalStemFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.es.SpanishLightStemFilter;
import org.apache.lucene.analysis.fa.PersianStemFilter;
import org.apache.lucene.analysis.fi.FinnishLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchMinimalStemFilter;
import org.apache.lucene.analysis.gl.GalicianMinimalStemFilter;
import org.apache.lucene.analysis.gl.GalicianStemFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.hu.HungarianLightStemFilter;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.analysis.it.ItalianLightStemFilter;
import org.apache.lucene.analysis.lv.LatvianStemFilter;
import org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import org.apache.lucene.analysis.no.NorwegianLightStemFilter;
import org.apache.lucene.analysis.no.NorwegianMinimalStemFilter;
import org.apache.lucene.analysis.pt.PortugueseLightStemFilter;
import org.apache.lucene.analysis.pt.PortugueseMinimalStemFilter;
import org.apache.lucene.analysis.pt.PortugueseStemFilter;
import org.apache.lucene.analysis.ru.RussianLightStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.sv.SwedishLightStemFilter;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.tartarus.snowball.SnowballStemmer;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.EstonianStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.IrishStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.KpStemmer;
import org.tartarus.snowball.ext.LithuanianStemmer;
import org.tartarus.snowball.ext.LovinsStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SerbianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class StemmerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final TokenStream EMPTY_TOKEN_STREAM = new EmptyTokenStream();
    private String language;

    StemmerTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        super(name, settings);
        this.language = Strings.capitalize((String)settings.get("language", settings.get("name", "porter")));
        this.create(EMPTY_TOKEN_STREAM).close();
    }

    public TokenStream create(TokenStream tokenStream) {
        if ("arabic".equalsIgnoreCase(this.language)) {
            return new ArabicStemFilter(tokenStream);
        }
        if ("armenian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new ArmenianStemmer());
        }
        if ("basque".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new BasqueStemmer());
        }
        if ("bengali".equalsIgnoreCase(this.language)) {
            return new BengaliStemFilter(tokenStream);
        }
        if ("brazilian".equalsIgnoreCase(this.language)) {
            return new BrazilianStemFilter(tokenStream);
        }
        if ("bulgarian".equalsIgnoreCase(this.language)) {
            return new BulgarianStemFilter(tokenStream);
        }
        if ("catalan".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new CatalanStemmer());
        }
        if ("czech".equalsIgnoreCase(this.language)) {
            return new CzechStemFilter(tokenStream);
        }
        if ("danish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new DanishStemmer());
        }
        if ("dutch".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new DutchStemmer());
        }
        if ("dutch_kp".equalsIgnoreCase(this.language) || "dutchKp".equalsIgnoreCase(this.language) || "kp".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new KpStemmer());
        }
        if ("english".equalsIgnoreCase(this.language)) {
            return new PorterStemFilter(tokenStream);
        }
        if ("light_english".equalsIgnoreCase(this.language) || "lightEnglish".equalsIgnoreCase(this.language) || "kstem".equalsIgnoreCase(this.language)) {
            return new KStemFilter(tokenStream);
        }
        if ("lovins".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new LovinsStemmer());
        }
        if ("porter".equalsIgnoreCase(this.language)) {
            return new PorterStemFilter(tokenStream);
        }
        if ("porter2".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new EnglishStemmer());
        }
        if ("minimal_english".equalsIgnoreCase(this.language) || "minimalEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishMinimalStemFilter(tokenStream);
        }
        if ("possessive_english".equalsIgnoreCase(this.language) || "possessiveEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishPossessiveFilter(tokenStream);
        }
        if ("estonian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new EstonianStemmer());
        }
        if ("finnish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new FinnishStemmer());
        }
        if ("light_finish".equalsIgnoreCase(this.language) || "lightFinish".equalsIgnoreCase(this.language)) {
            return new FinnishLightStemFilter(tokenStream);
        }
        if ("light_finnish".equalsIgnoreCase(this.language) || "lightFinnish".equalsIgnoreCase(this.language)) {
            return new FinnishLightStemFilter(tokenStream);
        }
        if ("french".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new FrenchStemmer());
        }
        if ("light_french".equalsIgnoreCase(this.language) || "lightFrench".equalsIgnoreCase(this.language)) {
            return new FrenchLightStemFilter(tokenStream);
        }
        if ("minimal_french".equalsIgnoreCase(this.language) || "minimalFrench".equalsIgnoreCase(this.language)) {
            return new FrenchMinimalStemFilter(tokenStream);
        }
        if ("galician".equalsIgnoreCase(this.language)) {
            return new GalicianStemFilter(tokenStream);
        }
        if ("minimal_galician".equalsIgnoreCase(this.language)) {
            return new GalicianMinimalStemFilter(tokenStream);
        }
        if ("german".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new GermanStemmer());
        }
        if ("german2".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new German2Stemmer());
        }
        if ("light_german".equalsIgnoreCase(this.language) || "lightGerman".equalsIgnoreCase(this.language)) {
            return new GermanLightStemFilter(tokenStream);
        }
        if ("minimal_german".equalsIgnoreCase(this.language) || "minimalGerman".equalsIgnoreCase(this.language)) {
            return new GermanMinimalStemFilter(tokenStream);
        }
        if ("greek".equalsIgnoreCase(this.language)) {
            return new GreekStemFilter(tokenStream);
        }
        if ("hindi".equalsIgnoreCase(this.language)) {
            return new HindiStemFilter(tokenStream);
        }
        if ("hungarian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new HungarianStemmer());
        }
        if ("light_hungarian".equalsIgnoreCase(this.language) || "lightHungarian".equalsIgnoreCase(this.language)) {
            return new HungarianLightStemFilter(tokenStream);
        }
        if ("indonesian".equalsIgnoreCase(this.language)) {
            return new IndonesianStemFilter(tokenStream);
        }
        if ("irish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new IrishStemmer());
        }
        if ("italian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new ItalianStemmer());
        }
        if ("light_italian".equalsIgnoreCase(this.language) || "lightItalian".equalsIgnoreCase(this.language)) {
            return new ItalianLightStemFilter(tokenStream);
        }
        if ("latvian".equalsIgnoreCase(this.language)) {
            return new LatvianStemFilter(tokenStream);
        }
        if ("lithuanian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new LithuanianStemmer());
        }
        if ("norwegian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new NorwegianStemmer());
        }
        if ("light_norwegian".equalsIgnoreCase(this.language) || "lightNorwegian".equalsIgnoreCase(this.language)) {
            return new NorwegianLightStemFilter(tokenStream);
        }
        if ("minimal_norwegian".equalsIgnoreCase(this.language) || "minimalNorwegian".equals(this.language)) {
            return new NorwegianMinimalStemFilter(tokenStream);
        }
        if ("light_nynorsk".equalsIgnoreCase(this.language) || "lightNynorsk".equalsIgnoreCase(this.language)) {
            return new NorwegianLightStemFilter(tokenStream, 2);
        }
        if ("minimal_nynorsk".equalsIgnoreCase(this.language) || "minimalNynorsk".equalsIgnoreCase(this.language)) {
            return new NorwegianMinimalStemFilter(tokenStream, 2);
        }
        if ("persian".equalsIgnoreCase(this.language)) {
            return new PersianStemFilter(tokenStream);
        }
        if ("portuguese".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new PortugueseStemmer());
        }
        if ("light_portuguese".equalsIgnoreCase(this.language) || "lightPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseLightStemFilter(tokenStream);
        }
        if ("minimal_portuguese".equalsIgnoreCase(this.language) || "minimalPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseMinimalStemFilter(tokenStream);
        }
        if ("portuguese_rslp".equalsIgnoreCase(this.language)) {
            return new PortugueseStemFilter(tokenStream);
        }
        if ("romanian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new RomanianStemmer());
        }
        if ("russian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new RussianStemmer());
        }
        if ("light_russian".equalsIgnoreCase(this.language) || "lightRussian".equalsIgnoreCase(this.language)) {
            return new RussianLightStemFilter(tokenStream);
        }
        if ("serbian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new SerbianStemmer());
        }
        if ("spanish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new SpanishStemmer());
        }
        if ("light_spanish".equalsIgnoreCase(this.language) || "lightSpanish".equalsIgnoreCase(this.language)) {
            return new SpanishLightStemFilter(tokenStream);
        }
        if ("sorani".equalsIgnoreCase(this.language)) {
            return new SoraniStemFilter(tokenStream);
        }
        if ("swedish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new SwedishStemmer());
        }
        if ("light_swedish".equalsIgnoreCase(this.language) || "lightSwedish".equalsIgnoreCase(this.language)) {
            return new SwedishLightStemFilter(tokenStream);
        }
        if ("turkish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballStemmer)new TurkishStemmer());
        }
        return new SnowballFilter(tokenStream, this.language);
    }
}

