/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.server.cli.JvmOption;

final class JvmErgonomics {
    private static final Pattern SYSTEM_PROPERTY = Pattern.compile("^-D(?<key>[\\w+].*?)=(?<value>.*)$");

    private JvmErgonomics() {
        throw new AssertionError((Object)"No instances intended");
    }

    static List<String> choose(List<String> userDefinedJvmOptions) throws InterruptedException, IOException {
        ArrayList<String> ergonomicChoices = new ArrayList<String>();
        Map<String, JvmOption> finalJvmOptions = JvmOption.findFinalOptions(userDefinedJvmOptions);
        long heapSize = JvmOption.extractMaxHeapSize(finalJvmOptions);
        long maxDirectMemorySize = JvmOption.extractMaxDirectMemorySize(finalJvmOptions);
        if (maxDirectMemorySize == 0L) {
            ergonomicChoices.add("-XX:MaxDirectMemorySize=" + heapSize / 2L);
        }
        boolean tuneG1GCForSmallHeap = JvmErgonomics.tuneG1GCForSmallHeap(heapSize);
        boolean tuneG1GCHeapRegion = JvmErgonomics.tuneG1GCHeapRegion(finalJvmOptions, tuneG1GCForSmallHeap);
        boolean tuneG1GCInitiatingHeapOccupancyPercent = JvmErgonomics.tuneG1GCInitiatingHeapOccupancyPercent(finalJvmOptions);
        int tuneG1GCReservePercent = JvmErgonomics.tuneG1GCReservePercent(finalJvmOptions, tuneG1GCForSmallHeap);
        if (tuneG1GCHeapRegion) {
            ergonomicChoices.add("-XX:G1HeapRegionSize=4m");
        }
        if (tuneG1GCInitiatingHeapOccupancyPercent) {
            ergonomicChoices.add("-XX:InitiatingHeapOccupancyPercent=30");
        }
        if (tuneG1GCReservePercent != 0) {
            ergonomicChoices.add("-XX:G1ReservePercent=" + tuneG1GCReservePercent);
        }
        return ergonomicChoices;
    }

    static boolean tuneG1GCForSmallHeap(long heapSize) {
        return heapSize < 0x200000000L;
    }

    static boolean tuneG1GCHeapRegion(Map<String, JvmOption> finalJvmOptions, boolean tuneG1GCForSmallHeap) {
        return tuneG1GCForSmallHeap && JvmErgonomics.usingG1GcWithoutCommandLineOriginOption(finalJvmOptions, "G1HeapRegionSize");
    }

    static int tuneG1GCReservePercent(Map<String, JvmOption> finalJvmOptions, boolean tuneG1GCForSmallHeap) {
        if (JvmErgonomics.usingG1GcWithoutCommandLineOriginOption(finalJvmOptions, "G1ReservePercent")) {
            return tuneG1GCForSmallHeap ? 15 : 25;
        }
        return 0;
    }

    static boolean tuneG1GCInitiatingHeapOccupancyPercent(Map<String, JvmOption> finalJvmOptions) {
        return JvmErgonomics.usingG1GcWithoutCommandLineOriginOption(finalJvmOptions, "InitiatingHeapOccupancyPercent");
    }

    private static boolean usingG1GcWithoutCommandLineOriginOption(Map<String, JvmOption> finalJvmOptions, String optionName) {
        return JvmErgonomics.getRequiredOption(finalJvmOptions, "UseG1GC").getMandatoryValue().equals("true") && !JvmErgonomics.getRequiredOption(finalJvmOptions, optionName).isCommandLineOrigin();
    }

    private static JvmOption getRequiredOption(Map<String, JvmOption> finalJvmOptions, String key) {
        JvmOption jvmOption = finalJvmOptions.get(key);
        if (jvmOption == null) {
            throw new IllegalStateException("JVM option [" + key + "] was unexpectedly missing. Elasticsearch requires this option to be present.");
        }
        return jvmOption;
    }

    static Map<String, String> extractSystemProperties(List<String> userDefinedJvmOptions) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (String jvmOption : userDefinedJvmOptions) {
            Matcher matcher = SYSTEM_PROPERTY.matcher(jvmOption);
            if (!matcher.matches()) continue;
            systemProperties.put(matcher.group("key"), matcher.group("value"));
        }
        return systemProperties;
    }
}

