/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.shared;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.blobcache.BlobCacheMetrics;
import org.elasticsearch.blobcache.BlobCacheUtils;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.blobcache.common.SparseFileTracker;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.blobcache.shared.SharedBytes;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.threadpool.ThreadPool;

public class SharedBlobCacheService<KeyType>
implements Releasable {
    private static final String SHARED_CACHE_SETTINGS_PREFIX = "xpack.searchable.snapshot.shared_cache.";
    public static final Setting<ByteSizeValue> SHARED_CACHE_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.range_size", ByteSizeValue.ofMb((long)16L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.range_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.recovery_range_size", ByteSizeValue.ofKb((long)128L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.recovery_range_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.recovery_range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_REGION_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.region_size", SHARED_CACHE_RANGE_SIZE_SETTING, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.region_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.region_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<RelativeByteSizeValue> SHARED_CACHE_SIZE_SETTING = new Setting((Setting.Key)new Setting.SimpleKey("xpack.searchable.snapshot.shared_cache.size"), settings -> {
        if (DiscoveryNode.isDedicatedFrozenNode((Settings)settings) || SharedBlobCacheService.isSearchOrIndexingNode(settings)) {
            return "90%";
        }
        return ByteSizeValue.ZERO.getStringRep();
    }, s -> RelativeByteSizeValue.parseRelativeByteSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size"), (Setting.Validator)new Setting.Validator<RelativeByteSizeValue>(){

        public void validate(RelativeByteSizeValue value) {
        }

        public void validate(RelativeByteSizeValue value, Map<Setting<?>, Object> settings) {
            if (value.isAbsolute() && value.getAbsolute().getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{"xpack.searchable.snapshot.shared_cache.size"});
            }
            if (value.isNonZeroSize()) {
                List roles = (List)settings.get(NodeRoleSettings.NODE_ROLES_SETTING);
                Set rolesSet = Set.copyOf(roles);
                if (!(DataTier.isFrozenNode(rolesSet) || rolesSet.contains(DiscoveryNodeRole.SEARCH_ROLE) || rolesSet.contains(DiscoveryNodeRole.INDEX_ROLE))) {
                    throw new SettingsException("Setting [{}] to be positive [{}] is only permitted on nodes with the data_frozen, search, or indexing role. Roles are [{}]", new Object[]{"xpack.searchable.snapshot.shared_cache.size", value.getStringRep(), roles.stream().map(DiscoveryNodeRole::roleName).collect(Collectors.joining(","))});
                }
                List dataPaths = (List)settings.get(Environment.PATH_DATA_SETTING);
                if (dataPaths.size() > 1) {
                    throw new SettingsException("setting [{}={}] is not permitted on nodes with multiple data paths [{}]", new Object[]{SHARED_CACHE_SIZE_SETTING.getKey(), value.getStringRep(), String.join((CharSequence)",", dataPaths)});
                }
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = List.of(NodeRoleSettings.NODE_ROLES_SETTING, Environment.PATH_DATA_SETTING);
            return settings.iterator();
        }
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING = new Setting((Setting.Key)new Setting.SimpleKey("xpack.searchable.snapshot.shared_cache.size.max_headroom"), settings -> {
        if (!SHARED_CACHE_SIZE_SETTING.exists(settings) && (DiscoveryNode.isDedicatedFrozenNode((Settings)settings) || SharedBlobCacheService.isSearchOrIndexingNode(settings))) {
            return "100GB";
        }
        return "-1";
    }, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size.max_headroom"), (Setting.Validator)new Setting.Validator<ByteSizeValue>(){
        private final Collection<Setting<?>> dependencies = List.of(SHARED_CACHE_SIZE_SETTING);

        public Iterator<Setting<?>> settings() {
            return this.dependencies.iterator();
        }

        public void validate(ByteSizeValue value) {
        }

        public void validate(ByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            RelativeByteSizeValue sizeValue;
            if (isPresent && value.getBytes() != -1L && (sizeValue = (RelativeByteSizeValue)settings.get(SHARED_CACHE_SIZE_SETTING)).isAbsolute()) {
                throw new SettingsException("setting [{}] cannot be specified for absolute [{}={}]", new Object[]{SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.getKey(), SHARED_CACHE_SIZE_SETTING.getKey(), sizeValue.getStringRep()});
            }
        }
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue MIN_SHARED_CACHE_DECAY_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<TimeValue> SHARED_CACHE_DECAY_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.decay.interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)MIN_SHARED_CACHE_DECAY_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SHARED_CACHE_MAX_FREQ_SETTING = Setting.intSetting((String)"xpack.searchable.snapshot.shared_cache.max_freq", (int)100, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SHARED_CACHE_MIN_TIME_DELTA_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.min_time_delta", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)TimeValue.timeValueSeconds((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SHARED_CACHE_MMAP = Setting.boolSetting((String)"xpack.searchable.snapshot.shared_cache.mmap", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SHARED_CACHE_COUNT_READS = Setting.boolSetting((String)"xpack.searchable.snapshot.shared_cache.count_reads", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(SharedBlobCacheService.class);
    private final ThreadPool threadPool;
    private final Executor ioExecutor;
    private final Executor bulkIOExecutor;
    private final SharedBytes sharedBytes;
    private final long cacheSize;
    private final int regionSize;
    private final int rangeSize;
    private final int recoveryRangeSize;
    private final int numRegions;
    private final ConcurrentLinkedQueue<SharedBytes.IO> freeRegions = new ConcurrentLinkedQueue();
    private final Cache<KeyType, CacheFileRegion> cache;
    private final ConcurrentHashMap<SharedBytes.IO, CacheFileRegion> regionOwners;
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder writeBytes = new LongAdder();
    private final LongAdder readCount = new LongAdder();
    private final LongAdder readBytes = new LongAdder();
    private final LongAdder evictCount = new LongAdder();
    private final BlobCacheMetrics blobCacheMetrics;

    private static Setting.Validator<ByteSizeValue> getPageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{settingName});
            }
            if (value.getBytes() % (long)SharedBytes.PAGE_SIZE != 0L) {
                throw new SettingsException("setting [{}] must be multiple of {}", new Object[]{settingName, SharedBytes.PAGE_SIZE});
            }
        };
    }

    private static Setting.Validator<ByteSizeValue> getPositivePageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() <= 0L) {
                throw new SettingsException("setting [{}] must be greater than zero", new Object[]{settingName});
            }
            SharedBlobCacheService.getPageSizeAlignedByteSizeValueValidator(settingName).validate(value);
        };
    }

    private static boolean isSearchOrIndexingNode(Settings settings) {
        return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.SEARCH_ROLE) || DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.INDEX_ROLE);
    }

    public SharedBlobCacheService(NodeEnvironment environment, Settings settings, ThreadPool threadPool, String ioExecutor, BlobCacheMetrics blobCacheMetrics) {
        this(environment, settings, threadPool, ioExecutor, ioExecutor, blobCacheMetrics);
    }

    public SharedBlobCacheService(NodeEnvironment environment, Settings settings, ThreadPool threadPool, String ioExecutor, String bulkExecutor, BlobCacheMetrics blobCacheMetrics) {
        long totalFsSize;
        this.threadPool = threadPool;
        this.ioExecutor = threadPool.executor(ioExecutor);
        this.bulkIOExecutor = threadPool.executor(bulkExecutor);
        try {
            totalFsSize = FsProbe.getTotal((FileStore)Environment.getFileStore((Path)environment.nodeDataPaths()[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to probe size of filesystem [" + environment.nodeDataPaths()[0] + "]");
        }
        this.cacheSize = SharedBlobCacheService.calculateCacheSize(settings, totalFsSize);
        int regionSize = Math.toIntExact(((ByteSizeValue)SHARED_CACHE_REGION_SIZE_SETTING.get(settings)).getBytes());
        this.numRegions = Math.toIntExact(this.cacheSize / (long)regionSize);
        this.regionOwners = Assertions.ENABLED ? new ConcurrentHashMap() : null;
        this.regionSize = regionSize;
        assert ((long)regionSize > 0L);
        this.cache = new LFUCache(settings);
        try {
            this.sharedBytes = new SharedBytes(this.numRegions, regionSize, environment, this.writeBytes::add, ((Boolean)SHARED_CACHE_COUNT_READS.get(settings)).booleanValue() ? this.readBytes::add : ignored -> {}, (Boolean)SHARED_CACHE_MMAP.get(settings));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (int i = 0; i < this.numRegions; ++i) {
            this.freeRegions.add(this.sharedBytes.getFileChannel(i));
        }
        this.rangeSize = BlobCacheUtils.toIntBytes(((ByteSizeValue)SHARED_CACHE_RANGE_SIZE_SETTING.get(settings)).getBytes());
        this.recoveryRangeSize = BlobCacheUtils.toIntBytes(((ByteSizeValue)SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING.get(settings)).getBytes());
        this.blobCacheMetrics = blobCacheMetrics;
    }

    public static long calculateCacheSize(Settings settings, long totalFsSize) {
        return ((RelativeByteSizeValue)SHARED_CACHE_SIZE_SETTING.get(settings)).calculateValue(ByteSizeValue.ofBytes((long)totalFsSize), (ByteSizeValue)SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.get(settings)).getBytes();
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public int getRecoveryRangeSize() {
        return this.recoveryRangeSize;
    }

    private int getRegion(long position) {
        return (int)(position / (long)this.regionSize);
    }

    private int getRegionRelativePosition(long position) {
        return (int)(position % (long)this.regionSize);
    }

    private long getRegionStart(int region) {
        return (long)region * (long)this.regionSize;
    }

    private long getRegionEnd(int region) {
        return (long)(region + 1) * (long)this.regionSize;
    }

    private int getEndingRegion(long position) {
        return this.getRegion(position - (long)(position % (long)this.regionSize == 0L ? 1 : 0));
    }

    private ByteRange mapSubRangeToRegion(ByteRange range, int region) {
        long rangeEnd;
        long regionStart = this.getRegionStart(region);
        long regionEnd = this.getRegionEnd(region);
        if (range.start() >= regionEnd || range.end() <= regionStart) {
            return ByteRange.EMPTY;
        }
        long rangeStart = Math.max(regionStart, range.start());
        if (rangeStart >= (rangeEnd = Math.min(regionEnd, range.end()))) {
            return ByteRange.EMPTY;
        }
        return ByteRange.of(this.getRegionRelativePosition(rangeStart), rangeEnd == regionEnd ? (long)this.regionSize : (long)this.getRegionRelativePosition(rangeEnd));
    }

    private int getRegionSize(long fileLength, int region) {
        int effectiveRegionSize;
        assert (fileLength > 0L);
        int maxRegion = this.getEndingRegion(fileLength);
        assert (region >= 0 && region <= maxRegion) : region + " - " + maxRegion;
        if (region == maxRegion && (long)(region + 1) * (long)this.regionSize != fileLength) {
            assert ((long)this.getRegionRelativePosition(fileLength) != 0L);
            effectiveRegionSize = this.getRegionRelativePosition(fileLength);
        } else {
            effectiveRegionSize = this.regionSize;
        }
        assert (this.getRegionStart(region) + (long)effectiveRegionSize <= fileLength);
        return effectiveRegionSize;
    }

    CacheFileRegion get(KeyType cacheKey, long fileLength, int region) {
        return (CacheFileRegion)((Object)this.cache.get(cacheKey, (long)fileLength, (int)region).chunk);
    }

    public boolean maybeFetchFullEntry(KeyType cacheKey, long length, RangeMissingHandler writer, ActionListener<Void> listener) {
        int finalRegion = this.getEndingRegion(length);
        if (this.freeRegionCount() < finalRegion) {
            listener.onResponse(null);
            return false;
        }
        long regionLength = this.regionSize;
        try (RefCountingListener refCountingListener = new RefCountingListener(listener);){
            for (int region = 0; region <= finalRegion; ++region) {
                CacheFileRegion entry;
                ByteRange rangeToWrite;
                if (region == finalRegion) {
                    regionLength = length - this.getRegionStart(region);
                }
                if ((rangeToWrite = ByteRange.of(0L, regionLength)).isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                ActionListener regionListener = refCountingListener.acquire(ignored -> {});
                try {
                    entry = this.get(cacheKey, length, region);
                }
                catch (AlreadyClosedException e2) {
                    regionListener.onResponse((Object)0);
                    boolean bl = false;
                    refCountingListener.close();
                    return bl;
                }
                entry.populateAndRead(rangeToWrite, rangeToWrite, (channel, pos, relativePos, len) -> Math.toIntExact(len), writer, this.bulkIOExecutor, (ActionListener<Integer>)regionListener.delegateResponse((l, e) -> {
                    if (e instanceof AlreadyClosedException) {
                        l.onResponse((Object)0);
                    } else {
                        l.onFailure(e);
                    }
                }));
            }
        }
        return true;
    }

    private static void throwAlreadyClosed(String message) {
        throw new AlreadyClosedException(message);
    }

    int freeRegionCount() {
        return this.freeRegions.size();
    }

    public Stats getStats() {
        return new Stats(this.numRegions, this.cacheSize, this.regionSize, this.evictCount.sum(), this.writeCount.sum(), this.writeBytes.sum(), this.readCount.sum(), this.readBytes.sum());
    }

    public void removeFromCache(KeyType cacheKey) {
        this.forceEvict(cacheKey::equals);
    }

    public int forceEvict(Predicate<KeyType> cacheKeyPredicate) {
        return this.cache.forceEvict(cacheKeyPredicate);
    }

    int getFreq(CacheFileRegion cacheFileRegion) {
        Cache<KeyType, CacheFileRegion> cache = this.cache;
        if (cache instanceof LFUCache) {
            LFUCache lfuCache = (LFUCache)cache;
            return lfuCache.getFreq(cacheFileRegion);
        }
        return -1;
    }

    public void close() {
        this.sharedBytes.decRef();
    }

    public CacheFile getCacheFile(KeyType cacheKey, long length) {
        return new CacheFile(cacheKey, length);
    }

    private class LFUCache
    implements Cache<KeyType, CacheFileRegion> {
        private final ConcurrentHashMap<RegionKey<KeyType>, org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry> keyMapping = new ConcurrentHashMap();
        private final org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry[] freqs;
        private final int maxFreq;
        private final long minTimeDelta;
        private final org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.CacheDecayTask decayTask;

        LFUCache(Settings settings) {
            this.maxFreq = (Integer)SHARED_CACHE_MAX_FREQ_SETTING.get(settings);
            this.minTimeDelta = ((TimeValue)SHARED_CACHE_MIN_TIME_DELTA_SETTING.get(settings)).millis();
            this.freqs = (LFUCacheEntry[])Array.newInstance(LFUCacheEntry.class, this.maxFreq);
            this.decayTask = new CacheDecayTask(SharedBlobCacheService.this.threadPool, SharedBlobCacheService.this.threadPool.generic(), (TimeValue)SHARED_CACHE_DECAY_INTERVAL_SETTING.get(settings));
            this.decayTask.rescheduleIfNecessary();
        }

        public void close() {
            this.decayTask.close();
        }

        int getFreq(CacheFileRegion cacheFileRegion) {
            return ((LFUCacheEntry)this.keyMapping.get(cacheFileRegion.regionKey)).freq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry get(KeyType cacheKey, long fileLength, int region) {
            RegionKey regionKey = new RegionKey(cacheKey, region);
            long now = SharedBlobCacheService.this.threadPool.relativeTimeInMillis();
            LFUCacheEntry entry = (LFUCacheEntry)this.keyMapping.get(regionKey);
            if (entry == null) {
                int effectiveRegionSize = SharedBlobCacheService.this.getRegionSize(fileLength, region);
                entry = this.keyMapping.computeIfAbsent(regionKey, key -> new LFUCacheEntry(new CacheFileRegion(key, effectiveRegionSize), now));
            }
            if (((CacheFileRegion)((Object)entry.chunk)).io == null) {
                CacheFileRegion cacheFileRegion = (CacheFileRegion)((Object)entry.chunk);
                synchronized (cacheFileRegion) {
                    if (((CacheFileRegion)((Object)entry.chunk)).io == null) {
                        return this.initChunk(entry);
                    }
                }
            }
            assert (this.assertChunkActiveOrEvicted(entry));
            if (now - entry.lastAccessed >= this.minTimeDelta) {
                this.maybePromote(now, entry);
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int forceEvict(Predicate<KeyType> cacheKeyPredicate) {
            ArrayList matchingEntries = new ArrayList();
            this.keyMapping.forEach((key, value) -> {
                if (cacheKeyPredicate.test(key.file)) {
                    matchingEntries.add(value);
                }
            });
            int evictedCount = 0;
            int nonZeroFrequencyEvictedCount = 0;
            if (!matchingEntries.isEmpty()) {
                SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
                synchronized (sharedBlobCacheService) {
                    for (LFUCacheEntry entry : matchingEntries) {
                        int frequency = entry.freq;
                        boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).forceEvict();
                        if (!evicted || ((CacheFileRegion)((Object)entry.chunk)).io == null) continue;
                        this.unlink(entry);
                        this.keyMapping.remove(((CacheFileRegion)((Object)entry.chunk)).regionKey, entry);
                        ++evictedCount;
                        if (frequency <= 0) continue;
                        ++nonZeroFrequencyEvictedCount;
                    }
                }
            }
            SharedBlobCacheService.this.blobCacheMetrics.getEvictedCountNonZeroFrequency().incrementBy((long)nonZeroFrequencyEvictedCount);
            return evictedCount;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LFUCacheEntry initChunk(LFUCacheEntry entry) {
            assert (Thread.holdsLock(entry.chunk));
            RegionKey regionKey = ((CacheFileRegion)((Object)entry.chunk)).regionKey;
            if (this.keyMapping.get(regionKey) != entry) {
                SharedBlobCacheService.throwAlreadyClosed("no free region found (contender)");
            }
            assert (entry.freq == 0);
            assert (entry.prev == null);
            assert (entry.next == null);
            SharedBytes.IO freeSlot = SharedBlobCacheService.this.freeRegions.poll();
            if (freeSlot != null) {
                this.assignToSlot(entry, freeSlot);
            } else {
                SharedBytes.IO freeSlotRetry;
                int frequency;
                SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
                synchronized (sharedBlobCacheService) {
                    frequency = this.maybeEvict();
                }
                if (frequency > 0) {
                    SharedBlobCacheService.this.blobCacheMetrics.getEvictedCountNonZeroFrequency().increment();
                }
                if ((freeSlotRetry = SharedBlobCacheService.this.freeRegions.poll()) != null) {
                    this.assignToSlot(entry, freeSlotRetry);
                } else {
                    boolean removed = this.keyMapping.remove(regionKey, entry);
                    assert (removed);
                    SharedBlobCacheService.throwAlreadyClosed("no free region found");
                }
            }
            return entry;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assignToSlot(LFUCacheEntry entry, SharedBytes.IO freeSlot) {
            assert (SharedBlobCacheService.this.regionOwners.put(freeSlot, (CacheFileRegion)((Object)entry.chunk)) == null);
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                if (((CacheFileRegion)((Object)entry.chunk)).isEvicted()) {
                    assert (SharedBlobCacheService.this.regionOwners.remove(freeSlot) == entry.chunk);
                    SharedBlobCacheService.this.freeRegions.add(freeSlot);
                    this.keyMapping.remove(((CacheFileRegion)((Object)entry.chunk)).regionKey, entry);
                    SharedBlobCacheService.throwAlreadyClosed("evicted during free region allocation");
                }
                this.pushEntryToBack(entry);
                ((CacheFileRegion)((Object)entry.chunk)).io = freeSlot;
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void pushEntryToBack(LFUCacheEntry entry) {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            assert (this.invariant(entry, false));
            assert (entry.prev == null);
            assert (entry.next == null);
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry currFront = this.freqs[entry.freq];
            if (currFront == null) {
                this.freqs[entry.freq] = entry;
                entry.prev = entry;
                entry.next = null;
            } else {
                assert (currFront.freq == entry.freq);
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry last = currFront.prev;
                currFront.prev = entry;
                last.next = entry;
                entry.prev = last;
                entry.next = null;
            }
            assert (this.freqs[entry.freq].prev == entry);
            assert (this.freqs[entry.freq].prev.next == null);
            assert (entry.prev != null);
            assert (entry.prev.next == null || entry.prev.next == entry);
            assert (entry.next == null);
            assert (this.invariant(entry, true));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private synchronized boolean invariant(LFUCacheEntry e, boolean present) {
            boolean found = false;
            for (int i = 0; i < this.maxFreq; ++i) {
                assert (this.freqs[i] == null || this.freqs[i].prev != null);
                assert (this.freqs[i] == null || this.freqs[i].prev != this.freqs[i] || this.freqs[i].next == null);
                assert (this.freqs[i] == null || this.freqs[i].prev.next == null);
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[i];
                while (entry != null) {
                    assert (entry.next == null || entry.next.prev == entry);
                    assert (entry.prev != null);
                    assert (entry.prev.next == null || entry.prev.next == entry);
                    assert (entry.freq == i);
                    if (entry == e) {
                        found = true;
                    }
                    entry = entry.next;
                }
                entry = this.freqs[i];
                while (entry != null && entry.prev != this.freqs[i]) {
                    assert (entry.next == null || entry.next.prev == entry);
                    assert (entry.prev != null);
                    assert (entry.prev.next == null || entry.prev.next == entry);
                    assert (entry.freq == i);
                    if (entry == e) {
                        found = true;
                    }
                    entry = entry.prev;
                }
            }
            assert (found == present);
            return true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean assertChunkActiveOrEvicted(LFUCacheEntry entry) {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                assert (entry.prev != null || ((CacheFileRegion)((Object)entry.chunk)).isEvicted());
            }
            assert (SharedBlobCacheService.this.regionOwners.get(((CacheFileRegion)((Object)entry.chunk)).io) == entry.chunk || ((CacheFileRegion)((Object)entry.chunk)).isEvicted());
            return true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybePromote(long now, LFUCacheEntry entry) {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                if (now - entry.lastAccessed >= this.minTimeDelta && entry.freq + 1 < this.maxFreq && !((CacheFileRegion)((Object)entry.chunk)).isEvicted()) {
                    this.unlink(entry);
                    ++entry.freq;
                    entry.lastAccessed = now;
                    this.pushEntryToBack(entry);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void unlink(LFUCacheEntry entry) {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            assert (this.invariant(entry, true));
            assert (entry.prev != null);
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry currFront = this.freqs[entry.freq];
            assert (currFront != null);
            if (currFront == entry) {
                this.freqs[entry.freq] = entry.next;
                if (entry.next != null) {
                    assert (entry.prev != entry);
                    entry.next.prev = entry.prev;
                }
            } else {
                if (entry.next != null) {
                    entry.next.prev = entry.prev;
                }
                entry.prev.next = entry.next;
                if (currFront.prev == entry) {
                    currFront.prev = entry.prev;
                }
            }
            entry.next = null;
            entry.prev = null;
            assert (this.invariant(entry, false));
        }

        private int maybeEvict() {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            for (int currentFreq = 0; currentFreq < this.maxFreq; ++currentFreq) {
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[currentFreq];
                while (entry != null) {
                    boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).tryEvict();
                    if (evicted && ((CacheFileRegion)((Object)entry.chunk)).io != null) {
                        this.unlink((LFUCacheEntry)entry);
                        this.keyMapping.remove(((CacheFileRegion)((Object)entry.chunk)).regionKey, entry);
                        return currentFreq;
                    }
                    entry = entry.next;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeDecay() {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                long now = SharedBlobCacheService.this.threadPool.relativeTimeInMillis();
                for (int i = 0; i < this.maxFreq; ++i) {
                    org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[i];
                    while (entry != null) {
                        if (entry.freq > 0 && now - entry.lastAccessed >= 2L * this.minTimeDelta) {
                            this.unlink((LFUCacheEntry)entry);
                            --entry.freq;
                            this.pushEntryToBack((LFUCacheEntry)entry);
                        }
                        entry = entry.next;
                    }
                }
            }
        }

        class LFUCacheEntry
        extends CacheEntry<CacheFileRegion> {
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry prev;
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry next;
            int freq;
            volatile long lastAccessed;

            LFUCacheEntry(CacheFileRegion chunk, long lastAccessed) {
                super(chunk);
                this.lastAccessed = lastAccessed;
            }

            @Override
            void touch() {
                long now = SharedBlobCacheService.this.threadPool.relativeTimeInMillis();
                if (now - this.lastAccessed >= LFUCache.this.minTimeDelta) {
                    LFUCache.this.maybePromote(now, this);
                }
            }
        }

        class CacheDecayTask
        extends AbstractAsyncTask {
            CacheDecayTask(ThreadPool threadPool, Executor executor, TimeValue interval) {
                super(logger, Objects.requireNonNull(threadPool), executor, Objects.requireNonNull(interval), true);
            }

            protected boolean mustReschedule() {
                return true;
            }

            public void runInternal() {
                LFUCache.this.computeDecay();
            }

            public String toString() {
                return "shared_cache_decay_task";
            }
        }
    }

    private static interface Cache<K, T>
    extends Releasable {
        public CacheEntry<T> get(K var1, long var2, int var4);

        public int forceEvict(Predicate<K> var1);
    }

    private static abstract class CacheEntry<T> {
        final T chunk;

        private CacheEntry(T chunk) {
            this.chunk = chunk;
        }

        abstract void touch();
    }

    class CacheFileRegion
    extends EvictableRefCounted {
        final RegionKey<KeyType> regionKey;
        final SparseFileTracker tracker;
        volatile SharedBytes.IO io = null;

        CacheFileRegion(RegionKey<KeyType> regionKey, int regionSize) {
            this.regionKey = regionKey;
            assert (regionSize > 0);
            this.tracker = new SparseFileTracker("file", regionSize);
        }

        public long physicalStartOffset() {
            SharedBytes.IO ioRef = this.io;
            return ioRef == null ? -1L : (long)this.regionKey.region * (long)SharedBlobCacheService.this.regionSize;
        }

        boolean tryEvict() {
            assert (Thread.holdsLock(SharedBlobCacheService.this)) : "must hold lock when evicting";
            if (this.refCount() <= 1 && this.evict()) {
                logger.trace("evicted {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
                SharedBlobCacheService.this.evictCount.increment();
                this.decRef();
                return true;
            }
            return false;
        }

        public boolean forceEvict() {
            assert (Thread.holdsLock(SharedBlobCacheService.this)) : "must hold lock when evicting";
            if (this.evict()) {
                logger.trace("force evicted {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
                SharedBlobCacheService.this.evictCount.increment();
                this.decRef();
                return true;
            }
            return false;
        }

        protected void closeInternal() {
            if (this.io != null) {
                assert (SharedBlobCacheService.this.regionOwners.remove(this.io) == this);
                SharedBlobCacheService.this.freeRegions.add(this.io);
            }
            logger.trace("closed {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
        }

        private void ensureOpen() {
            if (this.isEvicted()) {
                CacheFileRegion.throwAlreadyEvicted();
            }
        }

        private static void throwAlreadyEvicted() {
            SharedBlobCacheService.throwAlreadyClosed("File chunk is evicted");
        }

        boolean tryRead(ByteBuffer buf, long offset) throws IOException {
            int readBytes = this.io.read(buf, SharedBlobCacheService.this.getRegionRelativePosition(offset));
            if (this.isEvicted()) {
                buf.position(buf.position() - readBytes);
                return false;
            }
            return true;
        }

        void populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, Executor executor, ActionListener<Integer> listener) {
            Releasable resource = null;
            try {
                this.incRef();
                resource = Releasables.releaseOnce(() -> ((CacheFileRegion)this).decRef());
                this.ensureOpen();
                List<SparseFileTracker.Gap> gaps = this.tracker.waitForRange(rangeToWrite, rangeToRead, (ActionListener<Void>)ActionListener.runAfter(listener, () -> ((Releasable)resource).close()).delegateFailureAndWrap((l, success) -> {
                    SharedBytes.IO ioRef = this.io;
                    assert (SharedBlobCacheService.this.regionOwners.get(ioRef) == this);
                    int start = Math.toIntExact(rangeToRead.start());
                    int read = reader.onRangeAvailable(ioRef, start, start, Math.toIntExact(rangeToRead.length()));
                    assert ((long)read == rangeToRead.length()) : "partial read [" + read + "] does not match the range to read [" + rangeToRead.end() + "-" + rangeToRead.start() + "]";
                    SharedBlobCacheService.this.readCount.increment();
                    l.onResponse((Object)read);
                }));
                if (!gaps.isEmpty()) {
                    this.fillGaps(executor, writer, gaps);
                }
            }
            catch (Exception e) {
                CacheFileRegion.releaseAndFail(listener, resource, e);
            }
        }

        private void fillGaps(Executor executor, final RangeMissingHandler writer, List<SparseFileTracker.Gap> gaps) {
            final CacheFileRegion cacheFileRegion = this;
            for (final SparseFileTracker.Gap gap : gaps) {
                executor.execute((Runnable)new AbstractRunnable(){

                    protected void doRun() throws Exception {
                        CacheFileRegion.this.ensureOpen();
                        if (!cacheFileRegion.tryIncRef()) {
                            throw new AlreadyClosedException("File chunk [" + cacheFileRegion.regionKey + "] has been released");
                        }
                        try {
                            int start = Math.toIntExact(gap.start());
                            SharedBytes.IO ioRef = CacheFileRegion.this.io;
                            assert (SharedBlobCacheService.this.regionOwners.get(ioRef) == cacheFileRegion);
                            writer.fillCacheRange(ioRef, start, start, Math.toIntExact(gap.end() - (long)start), progress -> gap.onProgress(start + progress));
                            SharedBlobCacheService.this.writeCount.increment();
                        }
                        finally {
                            cacheFileRegion.decRef();
                        }
                        gap.onCompletion();
                    }

                    public void onFailure(Exception e) {
                        gap.onFailure(e);
                    }
                });
            }
        }

        private static void releaseAndFail(ActionListener<Integer> listener, Releasable decrementRef, Exception e) {
            try {
                Releasables.close((Releasable)decrementRef);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            listener.onFailure(e);
        }

        protected void alreadyClosed() {
            CacheFileRegion.throwAlreadyEvicted();
        }
    }

    @FunctionalInterface
    public static interface RangeAvailableHandler {
        public int onRangeAvailable(SharedBytes.IO var1, int var2, int var3, int var4) throws IOException;
    }

    @FunctionalInterface
    public static interface RangeMissingHandler {
        public void fillCacheRange(SharedBytes.IO var1, int var2, int var3, int var4, IntConsumer var5) throws IOException;
    }

    public record Stats(int numberOfRegions, long size, long regionSize, long evictCount, long writeCount, long writeBytes, long readCount, long readBytes) {
        public static final Stats EMPTY = new Stats(0, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public class CacheFile {
        private final KeyType cacheKey;
        private final long length;
        private CacheEntry<CacheFileRegion> lastAccessedRegion;

        private CacheFile(KeyType cacheKey, long length) {
            this.cacheKey = cacheKey;
            this.length = length;
        }

        public CacheFile copy() {
            return new CacheFile(this.cacheKey, this.length);
        }

        public long getLength() {
            return this.length;
        }

        public KeyType getCacheKey() {
            return this.cacheKey;
        }

        public boolean tryRead(ByteBuffer buf, long offset) throws IOException {
            long end;
            int endRegion;
            int startRegion = SharedBlobCacheService.this.getRegion(offset);
            if (startRegion != (endRegion = SharedBlobCacheService.this.getEndingRegion(end = offset + (long)buf.remaining()))) {
                return false;
            }
            CacheEntry<CacheFileRegion> fileRegion = this.lastAccessedRegion;
            if (fileRegion != null && ((CacheFileRegion)((Object)fileRegion.chunk)).regionKey.region == startRegion) {
                fileRegion.touch();
            } else {
                fileRegion = SharedBlobCacheService.this.cache.get(this.cacheKey, this.length, startRegion);
            }
            CacheFileRegion region = (CacheFileRegion)((Object)fileRegion.chunk);
            if (!region.tracker.checkAvailable(end - SharedBlobCacheService.this.getRegionStart(startRegion))) {
                return false;
            }
            boolean res = region.tryRead(buf, offset);
            this.lastAccessedRegion = res ? fileRegion : null;
            return res;
        }

        public int populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer) throws Exception {
            int endRegion;
            long startTime = SharedBlobCacheService.this.threadPool.relativeTimeInMillis();
            RangeMissingHandler writerInstrumentationDecorator = (channel, channelPos, relativePos, length, progressUpdater) -> {
                writer.fillCacheRange(channel, channelPos, relativePos, length, progressUpdater);
                long elapsedTime = SharedBlobCacheService.this.threadPool.relativeTimeInMillis() - startTime;
                SharedBlobCacheService.this.blobCacheMetrics.getCacheMissLoadTimes().record(elapsedTime);
                SharedBlobCacheService.this.blobCacheMetrics.getCacheMissCounter().increment();
            };
            if (rangeToRead.isEmpty()) {
                return 0;
            }
            int startRegion = SharedBlobCacheService.this.getRegion(rangeToWrite.start());
            if (startRegion == (endRegion = SharedBlobCacheService.this.getEndingRegion(rangeToWrite.end()))) {
                return this.readSingleRegion(rangeToWrite, rangeToRead, reader, writerInstrumentationDecorator, startRegion);
            }
            return this.readMultiRegions(rangeToWrite, rangeToRead, reader, writerInstrumentationDecorator, startRegion, endRegion);
        }

        private int readSingleRegion(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, int region) throws InterruptedException, ExecutionException {
            PlainActionFuture readFuture = new PlainActionFuture();
            CacheFileRegion fileRegion = SharedBlobCacheService.this.get(this.cacheKey, this.length, region);
            long regionStart = SharedBlobCacheService.this.getRegionStart(region);
            fileRegion.populateAndRead(SharedBlobCacheService.this.mapSubRangeToRegion(rangeToWrite, region), SharedBlobCacheService.this.mapSubRangeToRegion(rangeToRead, region), this.readerWithOffset(reader, fileRegion, Math.toIntExact(rangeToRead.start() - regionStart)), this.writerWithOffset(writer, fileRegion, Math.toIntExact(rangeToWrite.start() - regionStart)), SharedBlobCacheService.this.ioExecutor, (ActionListener<Integer>)readFuture);
            return (Integer)readFuture.get();
        }

        private int readMultiRegions(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, int startRegion, int endRegion) throws InterruptedException, ExecutionException {
            PlainActionFuture readsComplete = new PlainActionFuture();
            AtomicInteger bytesRead = new AtomicInteger();
            try (RefCountingListener listeners = new RefCountingListener(1, (ActionListener)readsComplete);){
                for (int region = startRegion; region <= endRegion; ++region) {
                    ByteRange subRangeToRead = SharedBlobCacheService.this.mapSubRangeToRegion(rangeToRead, region);
                    if (subRangeToRead.isEmpty()) continue;
                    ActionListener listener = listeners.acquire(i -> bytesRead.updateAndGet(j -> Math.addExact(i, j)));
                    try {
                        CacheFileRegion fileRegion = SharedBlobCacheService.this.get(this.cacheKey, this.length, region);
                        long regionStart = SharedBlobCacheService.this.getRegionStart(region);
                        fileRegion.populateAndRead(SharedBlobCacheService.this.mapSubRangeToRegion(rangeToWrite, region), subRangeToRead, this.readerWithOffset(reader, fileRegion, Math.toIntExact(rangeToRead.start() - regionStart)), this.writerWithOffset(writer, fileRegion, Math.toIntExact(rangeToWrite.start() - regionStart)), SharedBlobCacheService.this.ioExecutor, (ActionListener<Integer>)listener);
                        continue;
                    }
                    catch (Exception e) {
                        assert (e instanceof AlreadyClosedException) : e;
                        listener.onFailure(e);
                    }
                }
            }
            readsComplete.get();
            return bytesRead.get();
        }

        private RangeMissingHandler writerWithOffset(RangeMissingHandler writer, CacheFileRegion fileRegion, int writeOffset) {
            RangeMissingHandler adjustedWriter = writeOffset == 0 ? writer : (channel, channelPos, relativePos, len, progressUpdater) -> writer.fillCacheRange(channel, channelPos, relativePos - writeOffset, len, progressUpdater);
            if (Assertions.ENABLED) {
                return (channel, channelPos, relativePos, len, progressUpdater) -> {
                    assert (this.assertValidRegionAndLength(fileRegion, channelPos, len));
                    adjustedWriter.fillCacheRange(channel, channelPos, relativePos, len, progressUpdater);
                };
            }
            return adjustedWriter;
        }

        private RangeAvailableHandler readerWithOffset(RangeAvailableHandler reader, CacheFileRegion fileRegion, int readOffset) {
            RangeAvailableHandler adjustedReader = (channel, channelPos, relativePos, len) -> reader.onRangeAvailable(channel, channelPos, relativePos - readOffset, len);
            if (Assertions.ENABLED) {
                return (channel, channelPos, relativePos, len) -> {
                    assert (this.assertValidRegionAndLength(fileRegion, channelPos, len));
                    return adjustedReader.onRangeAvailable(channel, channelPos, relativePos, len);
                };
            }
            return adjustedReader;
        }

        private boolean assertValidRegionAndLength(CacheFileRegion fileRegion, int channelPos, int len) {
            assert (SharedBlobCacheService.this.regionOwners.get(fileRegion.io) == fileRegion);
            assert (channelPos >= 0 && channelPos + len <= SharedBlobCacheService.this.regionSize);
            return true;
        }

        public String toString() {
            return "SharedCacheFile{cacheKey=" + this.cacheKey + ", length=" + this.length + "}";
        }
    }

    private static abstract class EvictableRefCounted
    extends AbstractRefCounted {
        protected static final VarHandle VH_EVICTED_FIELD;
        private volatile int evicted = 0;

        private EvictableRefCounted() {
        }

        protected final boolean evict() {
            return VH_EVICTED_FIELD.compareAndSet(this, 0, 1);
        }

        public final boolean isEvicted() {
            return this.evicted != 0;
        }

        static {
            try {
                VH_EVICTED_FIELD = MethodHandles.lookup().in(EvictableRefCounted.class).findVarHandle(EvictableRefCounted.class, "evicted", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record RegionKey<KeyType>(KeyType file, int region) {
        @Override
        public String toString() {
            return "Chunk{file=" + this.file + ", region=" + this.region + "}";
        }
    }
}

