/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.core.Tuple;

class ProgressListenableActionFuture
extends PlainActionFuture<Long> {
    protected final long start;
    protected final long end;
    private volatile List<Tuple<Long, ActionListener<Long>>> listeners;
    protected volatile long progress;
    private volatile boolean completed;

    ProgressListenableActionFuture(long start, long end) {
        this.start = start;
        this.end = end;
        this.progress = start;
        this.completed = false;
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invariant() {
        assert (this.start < this.end) : this.start + " < " + this.end;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (!this.completed || this.listeners == null);
            assert (this.start <= this.progress) : this.start + " <= " + this.progress;
            assert (this.progress <= this.end) : this.progress + " <= " + this.end;
            assert (this.listeners == null || this.listeners.stream().allMatch(listener -> this.progress < (Long)listener.v1()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(long progressValue) {
        this.ensureNotCompleted();
        if (progressValue <= this.start) {
            assert (false) : progressValue + " <= " + this.start;
            throw new IllegalArgumentException("Cannot update progress with a value less than [start=" + this.start + "]");
        }
        if (this.end < progressValue) {
            assert (false) : this.end + " < " + progressValue;
            throw new IllegalArgumentException("Cannot update progress with a value greater than [end=" + this.end + "]");
        }
        ArrayList<ActionListener> listenersToExecute = null;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (this.progress < progressValue) : this.progress + " < " + progressValue;
            this.progress = progressValue;
            List<Tuple<Long, ActionListener<Long>>> listenersCopy = this.listeners;
            if (listenersCopy != null) {
                ArrayList<Tuple<Long, ActionListener<Long>>> listenersToKeep = null;
                for (Tuple<Long, ActionListener<Long>> listener2 : listenersCopy) {
                    if (progressValue < (Long)listener2.v1()) {
                        if (listenersToKeep == null) {
                            listenersToKeep = new ArrayList<Tuple<Long, ActionListener<Long>>>();
                        }
                        listenersToKeep.add(listener2);
                        continue;
                    }
                    if (listenersToExecute == null) {
                        listenersToExecute = new ArrayList<ActionListener>();
                    }
                    listenersToExecute.add((ActionListener)listener2.v2());
                }
                this.listeners = listenersToKeep;
            }
        }
        if (listenersToExecute != null) {
            listenersToExecute.forEach(listener -> ProgressListenableActionFuture.executeListener((ActionListener<Long>)listener, () -> progressValue));
        }
        assert (this.invariant());
    }

    public void onResponse(Long result) {
        if (result == null || result < this.start || this.end < result) {
            assert (false) : this.start + " < " + result + " < " + this.end;
            throw new IllegalArgumentException("Invalid completion value [start=" + this.start + ",end=" + this.end + ",response=" + result + "]");
        }
        this.ensureNotCompleted();
        super.onResponse((Object)result);
    }

    public void onFailure(Exception e) {
        this.ensureNotCompleted();
        super.onFailure(e);
    }

    private void ensureNotCompleted() {
        if (this.completed) {
            throw new IllegalStateException("Future is already completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done(boolean success) {
        List<Tuple<Long, ActionListener<Long>>> listenersToExecute;
        super.done(success);
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (this.progress == this.end || !success);
            this.completed = true;
            listenersToExecute = this.listeners;
            this.listeners = null;
        }
        if (listenersToExecute != null) {
            listenersToExecute.stream().map(Tuple::v2).forEach(listener -> ProgressListenableActionFuture.executeListener((ActionListener<Long>)listener, () -> ((ProgressListenableActionFuture)this).actionResult()));
        }
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<Long> listener, long value) {
        long progressValue;
        boolean executeImmediate = false;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            progressValue = this.progress;
            if (this.completed || value <= progressValue) {
                executeImmediate = true;
            } else {
                List<Tuple<Long, ActionListener<Long>>> listenersCopy = this.listeners;
                if (listenersCopy == null) {
                    listenersCopy = new ArrayList<Tuple<Long, ActionListener<Long>>>();
                }
                listenersCopy.add((Tuple<Long, ActionListener<Long>>)Tuple.tuple((Object)value, listener));
                this.listeners = listenersCopy;
            }
        }
        if (executeImmediate) {
            ProgressListenableActionFuture.executeListener(listener, this.completed ? () -> ((ProgressListenableActionFuture)this).actionResult() : () -> progressValue);
        }
        assert (this.invariant());
    }

    private static void executeListener(ActionListener<Long> listener, Supplier<Long> result) {
        try {
            listener.onResponse((Object)result.get());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public String toString() {
        return "ProgressListenableActionFuture[start=" + this.start + ", end=" + this.end + ", progress=" + this.progress + ", completed=" + this.completed + ", listeners=" + (this.listeners != null ? this.listeners.size() : 0) + "]";
    }
}

