/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.io.InputStream;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureAction;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderManager;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;

public class TransportFindStructureAction
extends HandledTransportAction<FindStructureAction.Request, FindStructureAction.Response> {
    private final ThreadPool threadPool;

    @Inject
    public TransportFindStructureAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool) {
        super("cluster:monitor/text_structure/findstructure", transportService, actionFilters, FindStructureAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, FindStructureAction.Request request, ActionListener<FindStructureAction.Response> listener) {
        this.threadPool.executor("generic").execute(() -> {
            try {
                listener.onResponse((Object)this.buildTextStructureResponse(request));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private FindStructureAction.Response buildTextStructureResponse(FindStructureAction.Request request) throws Exception {
        TextStructureFinderManager structureFinderManager = new TextStructureFinderManager(this.threadPool.scheduler());
        try (StreamInput sampleStream = request.getSample().streamInput();){
            TextStructureFinder textStructureFinder = structureFinderManager.findTextStructure(request.getLinesToSample(), request.getLineMergeSizeLimit(), (InputStream)sampleStream, new TextStructureOverrides(request), request.getTimeout());
            FindStructureAction.Response response = new FindStructureAction.Response(textStructureFinder.getStructure());
            return response;
        }
    }
}

