/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public record RoleDescriptorsIntersection(Collection<Set<RoleDescriptor>> roleDescriptorsList) implements ToXContentObject,
Writeable
{
    public static RoleDescriptorsIntersection EMPTY = new RoleDescriptorsIntersection(Collections.emptyList());

    public RoleDescriptorsIntersection(RoleDescriptor roleDescriptor) {
        this(List.of(Set.of(roleDescriptor)));
    }

    public RoleDescriptorsIntersection(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(inner -> inner.readCollectionAsSet(RoleDescriptor::new)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.roleDescriptorsList, StreamOutput::writeCollection);
    }

    public boolean isEmpty() {
        return this.roleDescriptorsList().isEmpty();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (Set<RoleDescriptor> roleDescriptors : this.roleDescriptorsList) {
            builder.startObject();
            for (RoleDescriptor roleDescriptor : roleDescriptors) {
                builder.field(roleDescriptor.getName(), (ToXContent)roleDescriptor);
            }
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public static RoleDescriptorsIntersection fromXContent(XContentParser xContentParser) throws IOException {
        if (xContentParser.currentToken() == null) {
            xContentParser.nextToken();
        }
        List roleDescriptorsList = XContentParserUtils.parseList((XContentParser)xContentParser, p -> {
            XContentParser.Token token = p.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)p);
            ArrayList<RoleDescriptor> roleDescriptors = new ArrayList<RoleDescriptor>();
            while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)p);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                roleDescriptors.add(RoleDescriptor.parse(p.currentName(), p, false));
            }
            return Set.copyOf(roleDescriptors);
        });
        return new RoleDescriptorsIntersection(List.copyOf(roleDescriptorsList));
    }
}

