/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public abstract class BaseBulkUpdateApiKeyRequest
extends BaseUpdateApiKeyRequest {
    private final List<String> ids;

    public BaseBulkUpdateApiKeyRequest(List<String> ids, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable Map<String, Object> metadata) {
        super(roleDescriptors, metadata);
        this.ids = Objects.requireNonNull(ids, "API key IDs must not be null");
    }

    public BaseBulkUpdateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.ids = in.readStringCollectionAsList();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.ids.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Field [ids] cannot be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.ids);
    }

    public List<String> getIds() {
        return this.ids;
    }
}

