/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteJobAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteJobAction INSTANCE = new DeleteJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/delete";
    public static final String DELETION_TASK_DESCRIPTION_PREFIX = "delete-job-";

    private DeleteJobAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String jobId;
        private boolean force;
        private boolean shouldStoreResult;
        private boolean deleteUserAnnotations;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.force = in.readBoolean();
            this.deleteUserAnnotations = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0) ? in.readBoolean() : false;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public void setShouldStoreResult(boolean shouldStoreResult) {
            this.shouldStoreResult = shouldStoreResult;
        }

        public boolean getShouldStoreResult() {
            return this.shouldStoreResult;
        }

        public void setDeleteUserAnnotations(boolean deleteUserAnnotations) {
            this.deleteUserAnnotations = deleteUserAnnotations;
        }

        public boolean getDeleteUserAnnotations() {
            return this.deleteUserAnnotations;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getDescription() {
            return DeleteJobAction.DELETION_TASK_DESCRIPTION_PREFIX + this.jobId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeBoolean(this.force);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0)) {
                out.writeBoolean(this.deleteUserAnnotations);
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.force, this.deleteUserAnnotations);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.force, other.force) && Objects.equals(this.deleteUserAnnotations, other.deleteUserAnnotations);
        }
    }
}

