/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ClearDeploymentCacheAction
extends ActionType<Response> {
    public static final ClearDeploymentCacheAction INSTANCE = new ClearDeploymentCacheAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/clear_cache";

    private ClearDeploymentCacheAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private final boolean cleared;

        public Response(boolean cleared) {
            super(Collections.emptyList(), Collections.emptyList());
            this.cleared = cleared;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.cleared = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.cleared);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("cleared", this.cleared);
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final String deploymentId;

        public Request(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, InferModelAction.Request.ID);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public boolean match(Task task) {
            return StartTrainedModelDeploymentAction.TaskMatcher.match(task, this.deploymentId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.deploymentId, request.deploymentId);
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId);
        }
    }
}

