/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;

public class DeleteAsyncResultsService {
    private static final Logger logger = LogManager.getLogger(DeleteAsyncResultsService.class);
    private final TaskManager taskManager;
    private final AsyncTaskIndexService<? extends AsyncResponse<?>> store;

    public DeleteAsyncResultsService(AsyncTaskIndexService<? extends AsyncResponse<?>> store, TaskManager taskManager) {
        this.taskManager = taskManager;
        this.store = store;
    }

    public void deleteResponse(DeleteAsyncResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.hasCancelTaskPrivilegeAsync(resp -> this.deleteResponseAsync(request, (boolean)resp, listener));
    }

    private void hasCancelTaskPrivilegeAsync(Consumer<Boolean> consumer) {
        Authentication current = this.store.getSecurityContext().getAuthentication();
        if (current != null) {
            HasPrivilegesRequest req = new HasPrivilegesRequest();
            req.username(current.getEffectiveSubject().getUser().principal());
            req.clusterPrivileges(ClusterPrivilegeResolver.CANCEL_TASK.name());
            req.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
            req.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            try {
                this.store.getClient().execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)req, ActionListener.wrap(resp -> consumer.accept(resp.isCompleteMatch()), exc -> consumer.accept(false)));
            }
            catch (Exception exc2) {
                consumer.accept(false);
            }
        } else {
            consumer.accept(false);
        }
    }

    private void deleteResponseAsync(DeleteAsyncResultRequest request, boolean hasCancelTaskPrivilege, ActionListener<AcknowledgedResponse> listener) {
        try {
            AsyncTask task;
            AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
            AsyncTask asyncTask = task = hasCancelTaskPrivilege ? AsyncTaskIndexService.getTask(this.taskManager, searchId, AsyncTask.class) : this.store.getTaskAndCheckAuthentication(this.taskManager, searchId, AsyncTask.class);
            if (task != null) {
                task.cancelTask(this.taskManager, () -> this.deleteResponseFromIndex(searchId, true, listener), "cancelled by user");
            } else if (hasCancelTaskPrivilege) {
                this.deleteResponseFromIndex(searchId, false, listener);
            } else {
                this.store.ensureAuthenticatedUserCanDeleteFromIndex(searchId, (ActionListener<Void>)listener.delegateFailureAndWrap((l, res) -> this.deleteResponseFromIndex(searchId, false, (ActionListener<AcknowledgedResponse>)l)));
            }
        }
        catch (Exception exc) {
            listener.onFailure((Exception)new ResourceNotFoundException(request.getId(), new Object[0]));
        }
    }

    private void deleteResponseFromIndex(AsyncExecutionId taskId, boolean taskWasFound, ActionListener<AcknowledgedResponse> listener) {
        this.store.deleteResponse(taskId, (ActionListener<DeleteResponse>)ActionListener.wrap(resp -> {
            if (resp.status() == RestStatus.OK || taskWasFound) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException(taskId.getEncoded(), new Object[0]));
            }
        }, exc -> {
            RestStatus status = ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)exc));
            if (status == RestStatus.NOT_FOUND && taskWasFound) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                logger.error(() -> "failed to clean async result [" + taskId.getEncoded() + "]", (Throwable)exc);
                listener.onFailure((Exception)new ResourceNotFoundException(taskId.getEncoded(), new Object[0]));
            }
        }));
    }
}

