/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportSettings;

public class RemoteClusterPortSettings {
    public static final TransportVersion TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY = TransportVersions.V_8_500_059;
    public static final String REMOTE_CLUSTER_PROFILE = "_remote_cluster";
    public static final String REMOTE_CLUSTER_PREFIX = "remote_cluster.";
    public static final Setting<Boolean> REMOTE_CLUSTER_SERVER_ENABLED = Setting.boolSetting("remote_cluster_server.enabled", false, Setting.Property.NodeScope);
    public static final Setting<List<String>> HOST = Setting.listSetting("remote_cluster.host", TransportSettings.BIND_HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> PUBLISH_HOST = Setting.listSetting("remote_cluster.publish_host", HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> BIND_HOST = Setting.listSetting("remote_cluster.bind_host", HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<Integer> PORT = Setting.intSetting("remote_cluster.port", 9443, 0, 65535, Setting.Property.NodeScope);
    public static final Setting<Integer> PUBLISH_PORT = Setting.intSetting("remote_cluster.publish_port", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_KEEP_ALIVE = Setting.boolSetting("remote_cluster.tcp.keep_alive", TransportSettings.TCP_KEEP_ALIVE, Setting.Property.NodeScope);
    public static final Setting<Integer> TCP_KEEP_IDLE = Setting.intSetting("remote_cluster.tcp.keep_idle", TransportSettings.TCP_KEEP_IDLE, -1, 300, Setting.Property.NodeScope);
    public static final Setting<Integer> TCP_KEEP_INTERVAL = Setting.intSetting("remote_cluster.tcp.keep_interval", TransportSettings.TCP_KEEP_INTERVAL, -1, 300, Setting.Property.NodeScope);
    public static final Setting<Integer> TCP_KEEP_COUNT = Setting.intSetting("remote_cluster.tcp.keep_count", TransportSettings.TCP_KEEP_COUNT, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_NO_DELAY = Setting.boolSetting("remote_cluster.tcp.no_delay", TransportSettings.TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_REUSE_ADDRESS = Setting.boolSetting("remote_cluster.tcp.reuse_address", TransportSettings.TCP_REUSE_ADDRESS, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("remote_cluster.tcp.send_buffer_size", TransportSettings.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("remote_cluster.tcp.receive_buffer_size", TransportSettings.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_REQUEST_HEADER_SIZE = Setting.byteSizeSetting("remote_cluster.max_request_header_size", new ByteSizeValue(64L, ByteSizeUnit.KB), new ByteSizeValue(64L, ByteSizeUnit.BYTES), new ByteSizeValue(2L, ByteSizeUnit.GB), Setting.Property.NodeScope);

    static void validateRemoteAccessSettings(Settings settings) {
        if (REMOTE_CLUSTER_SERVER_ENABLED.get(settings).booleanValue() && settings.getGroups("transport.profiles.", true).containsKey(REMOTE_CLUSTER_PROFILE)) {
            throw new IllegalArgumentException("Remote Access settings should not be configured using the [_remote_cluster] profile. Use the [remote_cluster.] settings instead.");
        }
    }

    public static TcpTransport.ProfileSettings buildRemoteAccessProfileSettings(Settings settings) {
        RemoteClusterPortSettings.validateRemoteAccessSettings(settings);
        Settings syntheticRemoteAccessProfile = Settings.builder().put(settings).put(TransportSettings.TCP_KEEP_ALIVE_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), (boolean)TCP_KEEP_ALIVE.get(settings)).put(TransportSettings.TCP_KEEP_IDLE_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), TCP_KEEP_IDLE.get(settings)).put(TransportSettings.TCP_KEEP_INTERVAL_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), TCP_KEEP_INTERVAL.get(settings)).put(TransportSettings.TCP_KEEP_COUNT_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), TCP_KEEP_COUNT.get(settings)).put(TransportSettings.TCP_NO_DELAY_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), (boolean)TCP_NO_DELAY.get(settings)).put(TransportSettings.TCP_REUSE_ADDRESS_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), (boolean)TCP_REUSE_ADDRESS.get(settings)).put(TransportSettings.TCP_SEND_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), TCP_SEND_BUFFER_SIZE.get(settings)).put(TransportSettings.TCP_RECEIVE_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), TCP_RECEIVE_BUFFER_SIZE.get(settings)).putList(TransportSettings.BIND_HOST_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), BIND_HOST.get(settings)).putList(TransportSettings.PUBLISH_HOST_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), PUBLISH_HOST.get(settings)).put(TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), PORT.get(settings)).put(TransportSettings.PUBLISH_PORT_PROFILE.getConcreteSettingForNamespace(REMOTE_CLUSTER_PROFILE).getKey(), PUBLISH_PORT.get(settings)).build();
        return new TcpTransport.ProfileSettings(syntheticRemoteAccessProfile, REMOTE_CLUSTER_PROFILE);
    }
}

