/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;

public class FetchDocValuesContext {
    private final Collection<FieldAndFormat> fields;

    public FetchDocValuesContext(SearchExecutionContext searchExecutionContext, List<FieldAndFormat> fieldPatterns) {
        LinkedHashMap<String, FieldAndFormat> fieldToFormats = new LinkedHashMap<String, FieldAndFormat>();
        for (FieldAndFormat field : fieldPatterns) {
            Set<String> fieldNames = searchExecutionContext.getMatchingFieldNames(field.field);
            for (String fieldName : fieldNames) {
                fieldToFormats.put(fieldName, new FieldAndFormat(fieldName, field.format, field.includeUnmapped));
            }
        }
        this.fields = fieldToFormats.values();
        int maxAllowedDocvalueFields = searchExecutionContext.getIndexSettings().getMaxDocvalueFields();
        if (this.fields.size() > maxAllowedDocvalueFields) {
            throw new IllegalArgumentException("Trying to retrieve too many docvalue_fields. Must be less than or equal to: [" + maxAllowedDocvalueFields + "] but was [" + this.fields.size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey() + "] index level setting.");
        }
    }

    public Collection<FieldAndFormat> fields() {
        return this.fields;
    }
}

