/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedMin
extends ParsedSingleValueNumericMetricsAggregation {
    private static final ObjectParser<ParsedMin, Void> PARSER = new ObjectParser(ParsedMin.class.getSimpleName(), true, ParsedMin::new);

    @Override
    public String getType() {
        return "min";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedMin fromXContent(XContentParser parser, String name) {
        ParsedMin min = (ParsedMin)PARSER.apply(parser, null);
        min.setName(name);
        return min;
    }

    static {
        ParsedMin.declareSingleValueFields(PARSER, Double.POSITIVE_INFINITY);
    }
}

