/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class InternalCardinality
extends InternalNumericMetricsAggregation.SingleValue
implements Cardinality {
    private final AbstractHyperLogLogPlusPlus counts;

    InternalCardinality(String name, AbstractHyperLogLogPlusPlus counts, Map<String, Object> metadata) {
        super(name, null, metadata);
        this.counts = counts;
    }

    public InternalCardinality(StreamInput in) throws IOException {
        super(in);
        this.counts = in.readBoolean() ? AbstractHyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE) : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        if (this.counts != null) {
            out.writeBoolean(true);
            this.counts.writeTo(0L, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return "cardinality";
    }

    static InternalCardinality empty(String name, Map<String, Object> metadata) {
        return new InternalCardinality(name, null, metadata);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.counts == null ? 0L : this.counts.cardinality(0L);
    }

    public AbstractHyperLogLogPlusPlus getCounts() {
        return this.counts;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        HyperLogLogPlusPlus reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalCardinality cardinality = (InternalCardinality)aggregation;
            if (cardinality.counts == null) continue;
            if (reduced == null) {
                reduced = new HyperLogLogPlusPlus(cardinality.counts.precision(), BigArrays.NON_RECYCLING_INSTANCE, 1L);
            }
            reduced.merge(0L, cardinality.counts, 0L);
        }
        if (reduced == null) {
            return aggregations.get(0);
        }
        return new InternalCardinality(this.name, reduced, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        long cardinality = this.getValue();
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), cardinality);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.counts == null ? 0 : this.counts.hashCode(0L));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCardinality other = (InternalCardinality)obj;
        if (this.counts == null) {
            return other.counts == null;
        }
        return this.counts.equals(0L, other.counts, 0L);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    AbstractHyperLogLogPlusPlus getState() {
        return this.counts;
    }
}

