/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ParseField;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SignificantTermsAggregatorFactory.class);
    private final SignificantTermsAggregatorSupplier aggregatorSupplier;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final QueryBuilder backgroundFilter;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD, CoreValuesSourceType.IP), SignificantTermsAggregatorFactory.bytesSupplier(), true);
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), SignificantTermsAggregatorFactory.numericSupplier(), true);
    }

    private static SignificantTermsAggregatorSupplier bytesSupplier() {
        return (name, factories, valuesSourceConfig, format, bucketCountThresholds, includeExclude, executionHint, context, parent, significanceHeuristic, lookup, cardinality, metadata) -> {
            ExecutionMode execution = null;
            if (executionHint != null) {
                execution = ExecutionMode.fromString(executionHint, deprecationLogger);
            }
            if (!valuesSourceConfig.hasOrdinals() || SignificantTermsAggregatorFactory.matchNoDocs(context, parent)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = ExecutionMode.GLOBAL_ORDINALS;
            }
            if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(name, factories, valuesSourceConfig, format, bucketCountThresholds, includeExclude, context, parent, significanceHeuristic, lookup, cardinality, metadata);
        };
    }

    static boolean matchNoDocs(AggregationContext context, Aggregator parent) {
        if (context.query() instanceof MatchNoDocsQuery) {
            while (parent != null) {
                if (parent instanceof GlobalAggregator) {
                    return false;
                }
                parent = parent.parent();
            }
            return true;
        }
        return false;
    }

    private static SignificantTermsAggregatorSupplier numericSupplier() {
        return (name, factories, valuesSourceConfig, format, bucketCountThresholds, includeExclude, executionHint, context, parent, significanceHeuristic, lookup, cardinality, metadata) -> {
            if (includeExclude != null && includeExclude.isRegexBased()) {
                throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
            }
            ValuesSource.Numeric numericValuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            if (numericValuesSource.isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            IncludeExclude.LongFilter longFilter = null;
            if (includeExclude != null) {
                longFilter = includeExclude.convertToLongFilter(format);
            }
            return new NumericTermsAggregator(name, factories, agg -> {
                NumericTermsAggregator numericTermsAggregator = agg;
                Objects.requireNonNull(numericTermsAggregator);
                return new NumericTermsAggregator.SignificantLongTermsResults(numericTermsAggregator, lookup, significanceHeuristic, cardinality);
            }, numericValuesSource, format, null, bucketCountThresholds, context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, longFilter, cardinality, metadata);
        };
    }

    SignificantTermsAggregatorFactory(String name, ValuesSourceConfig config, IncludeExclude includeExclude, String executionHint, QueryBuilder backgroundFilter, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, SignificantTermsAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        if (config.hasValues() && !config.fieldContext().fieldType().isSearchable()) {
            throw new IllegalArgumentException("SignificantText aggregation requires fields to be searchable, but [" + config.fieldContext().fieldType().name() + "] is not");
        }
        this.aggregatorSupplier = aggregatorSupplier;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.backgroundFilter = backgroundFilter;
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SamplingContext samplingContext;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.shardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        if ((samplingContext = this.getSamplingContext().orElse(SamplingContext.NONE)).isSampled() && (bucketCountThresholds.getMinDocCount() != SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.minDocCount() && bucketCountThresholds.getMinDocCount() > 1L || bucketCountThresholds.getShardMinDocCount() != SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.minDocCount() && bucketCountThresholds.getShardMinDocCount() > 1L)) {
            throw new ElasticsearchStatusException("aggregation [{}] is within a sampling context; min_doc_count, provided [{}], and min_shard_doc_count, provided [{}], cannot be greater than 1", RestStatus.BAD_REQUEST, this.name(), bucketCountThresholds.getMinDocCount(), bucketCountThresholds.getShardMinDocCount());
        }
        SignificanceLookup lookup = new SignificanceLookup(this.context, samplingContext, this.config.fieldContext().fieldType(), this.config.format(), this.backgroundFilter);
        return this.aggregatorSupplier.build(this.name, this.factories, this.config, this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, this.context, parent, this.significanceHeuristic, lookup, cardinality, metadata);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSourceConfig), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return mapStringTermsAggregator.new MapStringTermsAggregator.SignificantTermsResults(lookup, significanceHeuristic, cardinality);
                }, null, format, bucketCountThresholds, filter, context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                boolean remapGlobalOrd = true;
                if (cardinality == CardinalityUpperBound.ONE && factories == AggregatorFactories.EMPTY && includeExclude == null) {
                    remapGlobalOrd = false;
                }
                ValuesSource.Bytes.WithOrdinals.FieldData ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSourceConfig.getValuesSource();
                SortedSetDocValues values = TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource);
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> {
                    GlobalOrdinalsStringTermsAggregator globalOrdinalsStringTermsAggregator = a;
                    Objects.requireNonNull(globalOrdinalsStringTermsAggregator);
                    return globalOrdinalsStringTermsAggregator.new GlobalOrdinalsStringTermsAggregator.SignificantTermsResults(lookup, significanceHeuristic, cardinality);
                }, ordinalsValuesSource, () -> TermsAggregatorFactory.globalOrdsValues(context, ordinalsValuesSource), null, format, bucketCountThresholds, TermsAggregatorFactory.gloabalOrdsFilter(includeExclude, format, values), context, parent, remapGlobalOrd, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            if ("global_ordinals".equals(value)) {
                return GLOBAL_ORDINALS;
            }
            if ("global_ordinals_hash".equals(value)) {
                deprecationLogger.warn(DeprecationCategory.AGGREGATIONS, "global_ordinals_hash", "global_ordinals_hash is deprecated. Please use [global_ordinals] instead.", new Object[0]);
                return GLOBAL_ORDINALS;
            }
            if ("map".equals(value)) {
                return MAP;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSourceConfig var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, AggregationContext var7, Aggregator var8, SignificanceHeuristic var9, SignificanceLookup var10, CardinalityUpperBound var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

