/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.function.IntSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.hppc.BitMixer;
import org.elasticsearch.search.aggregations.bucket.sampler.random.FastGeometric;

public final class RandomSamplingQuery
extends Query {
    private final double p;
    private final int seed;
    private final int hash;

    public RandomSamplingQuery(double p, int seed, int hash) {
        if (p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("RandomSampling probability must be between 0.0 and 1.0, was [" + p + "]");
        }
        this.p = p;
        this.seed = seed;
        this.hash = hash;
    }

    public String toString(String field) {
        return "RandomSamplingQuery{p=" + this.p + ", seed=" + this.seed + ", hash=" + this.hash + "}";
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                boolean exists;
                Scorer s = this.scorer(context);
                boolean bl = exists = s.iterator().advance(doc) == doc;
                if (exists) {
                    return Explanation.match((Number)Float.valueOf(boost), (String)this.getQuery().toString(), (Explanation[])new Explanation[0]);
                }
                return Explanation.noMatch((String)(this.getQuery().toString() + " doesn't match id " + doc), (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) {
                SplittableRandom random = new SplittableRandom(BitMixer.mix((int)(RandomSamplingQuery.this.hash ^ RandomSamplingQuery.this.seed)));
                int maxDoc = context.reader().maxDoc();
                return new ConstantScoreScorer((Weight)this, boost, ScoreMode.COMPLETE_NO_SCORES, (DocIdSetIterator)new RandomSamplingIterator(maxDoc, RandomSamplingQuery.this.p, random::nextInt));
            }
        };
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RandomSamplingQuery that = (RandomSamplingQuery)((Object)o);
        return Double.compare(that.p, this.p) == 0 && this.seed == that.seed && this.hash == that.hash;
    }

    public int hashCode() {
        return Objects.hash(this.p, this.seed, this.hash);
    }

    static class RandomSamplingIterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private final double p;
        private final FastGeometric distribution;
        private int doc = -1;

        RandomSamplingIterator(int maxDoc, double p, IntSupplier rng) {
            this.maxDoc = maxDoc;
            this.p = p;
            this.distribution = new FastGeometric(rng, p);
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) {
            while (this.doc < target && this.doc < this.maxDoc) {
                this.doc += this.distribution.next();
            }
            this.doc = this.doc < this.maxDoc ? this.doc : Integer.MAX_VALUE;
            return this.doc;
        }

        public long cost() {
            return (long)((double)this.maxDoc * this.p);
        }
    }
}

