/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class InternalBinaryRange
extends InternalMultiBucketAggregation<InternalBinaryRange, Bucket>
implements Range {
    protected final DocValueFormat format;
    protected final boolean keyed;
    private final List<Bucket> buckets;

    public InternalBinaryRange(String name, DocValueFormat format, boolean keyed, List<Bucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.format = format;
        this.keyed = keyed;
        this.buckets = buckets;
    }

    public InternalBinaryRange(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.buckets = in.readCollectionAsList(stream -> Bucket.createFromStream(stream, this.format, this.keyed));
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeCollection(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "ip_range";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    public InternalBinaryRange create(List<Bucket> buckets) {
        return new InternalBinaryRange(this.name, this.format, this.keyed, buckets, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(this.format, this.keyed, prototype.key, prototype.from, prototype.to, prototype.docCount, aggregations);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        int i;
        reduceContext.consumeBucketsAndMaybeBreak(this.buckets.size());
        long[] docCounts = new long[this.buckets.size()];
        InternalAggregations[][] aggs = new InternalAggregations[this.buckets.size()][];
        for (i = 0; i < aggs.length; ++i) {
            aggs[i] = new InternalAggregations[aggregations.size()];
        }
        for (i = 0; i < aggregations.size(); ++i) {
            InternalBinaryRange range = (InternalBinaryRange)aggregations.get(i);
            if (range.buckets.size() != this.buckets.size()) {
                throw new IllegalStateException("Expected [" + this.buckets.size() + "] buckets, but got [" + range.buckets.size() + "]");
            }
            for (int j = 0; j < this.buckets.size(); ++j) {
                Bucket bucket = range.buckets.get(j);
                int n = j;
                docCounts[n] = docCounts[n] + bucket.docCount;
                aggs[j][i] = bucket.aggregations;
            }
        }
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(this.buckets.size());
        for (int i2 = 0; i2 < this.buckets.size(); ++i2) {
            Bucket b = this.buckets.get(i2);
            buckets.add(new Bucket(this.format, this.keyed, b.key, b.from, b.to, docCounts[i2], InternalAggregations.reduce(Arrays.asList(aggs[i2]), reduceContext)));
        }
        return new InternalBinaryRange(this.name, this.format, this.keyed, buckets, this.metadata);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalBinaryRange(this.name, this.format, this.keyed, this.buckets.stream().map(b -> b.finalizeSampling(samplingContext)).toList(), this.metadata);
    }

    @Override
    protected Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (buckets.size() > 0);
        List<InternalAggregations> aggregationsList = buckets.stream().map(bucket -> bucket.aggregations).toList();
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return this.createBucket(aggs, buckets.get(0));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket range : this.buckets) {
            range.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalBinaryRange that = (InternalBinaryRange)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.keyed);
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Range.Bucket {
        private final transient DocValueFormat format;
        private final transient boolean keyed;
        private final String key;
        private final BytesRef from;
        private final BytesRef to;
        private final long docCount;
        private final InternalAggregations aggregations;

        public Bucket(DocValueFormat format, boolean keyed, String key, BytesRef from, BytesRef to, long docCount, InternalAggregations aggregations) {
            this.format = format;
            this.keyed = keyed;
            this.key = key;
            this.from = from;
            this.to = to;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        private static String generateKey(BytesRef from, BytesRef to, DocValueFormat format) {
            return (from == null ? "*" : format.format(from)) + "-" + (to == null ? "*" : format.format(to));
        }

        private static Bucket createFromStream(StreamInput in, DocValueFormat format, boolean keyed) throws IOException {
            String key = in.getTransportVersion().equals(TransportVersions.V_8_0_0) ? in.readString() : (in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_1) ? in.readOptionalString() : in.readString());
            BytesRef from = in.readBoolean() ? in.readBytesRef() : null;
            BytesRef to = in.readBoolean() ? in.readBytesRef() : null;
            long docCount = in.readLong();
            InternalAggregations aggregations = InternalAggregations.readFrom(in);
            return new Bucket(format, keyed, key, from, to, docCount, aggregations);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().equals(TransportVersions.V_8_0_0)) {
                out.writeString(this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key);
            } else if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_1)) {
                out.writeOptionalString(this.key);
            } else {
                out.writeString(this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key);
            }
            out.writeBoolean(this.from != null);
            if (this.from != null) {
                out.writeBytesRef(this.from);
            }
            out.writeBoolean(this.to != null);
            if (this.to != null) {
                out.writeBytesRef(this.to);
            }
            out.writeLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            return this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String key = this.getKeyAsString();
            if (this.keyed) {
                builder.startObject(key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), key);
            }
            if (this.from != null) {
                builder.field(Aggregation.CommonFields.FROM.getPreferredName(), this.getFrom());
            }
            if (this.to != null) {
                builder.field(Aggregation.CommonFields.TO.getPreferredName(), this.getTo());
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public Object getFrom() {
            return this.getFromAsString();
        }

        @Override
        public String getFromAsString() {
            return this.from == null ? null : this.format.format(this.from).toString();
        }

        @Override
        public Object getTo() {
            return this.getToAsString();
        }

        @Override
        public String getToAsString() {
            return this.to == null ? null : this.format.format(this.to).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            if (this.docCount != bucket.docCount) {
                return false;
            }
            return Objects.equals(this.key, bucket.key) && Objects.equals(this.from, bucket.from) && Objects.equals(this.to, bucket.to) && Objects.equals(this.aggregations, bucket.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.key, this.from, this.to, this.aggregations);
        }

        Bucket finalizeSampling(SamplingContext samplingContext) {
            return new Bucket(this.format, this.keyed, this.key, this.from, this.to, samplingContext.scaleUp(this.docCount), InternalAggregations.finalizeSampling(this.aggregations, samplingContext));
        }
    }
}

