/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import org.elasticsearch.index.fielddata.AbstractSortingNumericDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public abstract class CellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;
    private final boolean crossesDateline;
    protected final LongConsumer circuitBreakerConsumer;

    protected CellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox, LongConsumer circuitBreakerConsumer) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
        this.crossesDateline = geoBoundingBox.left() > geoBoundingBox.right();
        this.circuitBreakerConsumer = circuitBreakerConsumer;
    }

    protected final int precision() {
        return this.precision;
    }

    @Override
    public final boolean isFloatingPoint() {
        return false;
    }

    @Override
    public final SortedNumericDocValues longValues(LeafReaderContext ctx) {
        MultiGeoPointValues multiGeoPointValues = this.valuesSource.geoPointValues(ctx);
        GeoPointValues values = FieldData.unwrapSingleton(multiGeoPointValues);
        if (this.geoBoundingBox.isUnbounded()) {
            return values == null ? this.unboundedCellMultiValues(multiGeoPointValues) : DocValues.singleton((NumericDocValues)this.unboundedCellSingleValue(values));
        }
        return values == null ? this.boundedCellMultiValues(multiGeoPointValues, this.geoBoundingBox) : DocValues.singleton((NumericDocValues)this.boundedCellSingleValue(values, this.geoBoundingBox));
    }

    protected abstract NumericDocValues unboundedCellSingleValue(GeoPointValues var1);

    protected abstract NumericDocValues boundedCellSingleValue(GeoPointValues var1, GeoBoundingBox var2);

    protected abstract SortedNumericDocValues unboundedCellMultiValues(MultiGeoPointValues var1);

    protected abstract SortedNumericDocValues boundedCellMultiValues(MultiGeoPointValues var1, GeoBoundingBox var2);

    @Override
    public final SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected boolean pointInBounds(double lon, double lat) {
        if (this.geoBoundingBox.top() > lat && this.geoBoundingBox.bottom() < lat) {
            if (this.crossesDateline) {
                return this.geoBoundingBox.left() < lon || this.geoBoundingBox.right() > lon;
            }
            return this.geoBoundingBox.left() < lon && this.geoBoundingBox.right() > lon;
        }
        return false;
    }

    protected static abstract class CellSingleValue
    extends AbstractNumericDocValues {
        private final GeoPointValues geoValues;
        protected final int precision;
        protected long value;

        protected CellSingleValue(GeoPointValues geoValues, int precision) {
            this.geoValues = geoValues;
            this.precision = precision;
        }

        public boolean advanceExact(int docId) throws IOException {
            return this.geoValues.advanceExact(docId) && this.advance(this.geoValues.pointValue());
        }

        public long longValue() throws IOException {
            return this.value;
        }

        protected abstract boolean advance(GeoPoint var1);

        public int docID() {
            return -1;
        }
    }

    protected static abstract class CellMultiValues
    extends AbstractSortingNumericDocValues {
        private final MultiGeoPointValues geoValues;
        protected final int precision;

        protected CellMultiValues(MultiGeoPointValues geoValues, int precision, LongConsumer circuitBreakerConsumer) {
            super(circuitBreakerConsumer);
            this.geoValues = geoValues;
            this.precision = precision;
        }

        public boolean advanceExact(int docId) throws IOException {
            if (this.geoValues.advanceExact(docId)) {
                int docValueCount = this.geoValues.docValueCount();
                this.resize(docValueCount);
                int j = 0;
                for (int i = 0; i < docValueCount; ++i) {
                    j = this.advanceValue(this.geoValues.nextValue(), j);
                }
                this.resize(j);
                this.sort();
                return true;
            }
            return false;
        }

        protected abstract int advanceValue(GeoPoint var1, int var2);
    }
}

