/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.countedterms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class CountedTermsAggregator
extends TermsAggregator {
    private final BytesKeyedBucketOrds bucketOrds;
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;

    CountedTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, bucketCountThresholds, order, format, Aggregator.SubAggCollectionMode.DEPTH_FIRST, metadata);
        this.valuesSource = valuesSource;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final SortedSetDocValues ords = this.valuesSource.ordinalsValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, ords){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (!ords.advanceExact(doc)) {
                    return;
                }
                long ord = ords.nextOrd();
                while (ord != -1L) {
                    long bucketOrdinal = CountedTermsAggregator.this.bucketOrds.add(owningBucketOrd, ords.lookupOrd(ord));
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        CountedTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                    } else {
                        CountedTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                    }
                    ord = ords.nextOrd();
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        StringTerms.Bucket[][] topBucketsPerOrd = new StringTerms.Bucket[owningBucketOrds.length][];
        long[] otherDocCounts = new long[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
            BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.partiallyBuiltBucketComparator);
            StringTerms.Bucket spare = null;
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            Supplier<StringTerms.Bucket> emptyBucketBuilder = () -> new StringTerms.Bucket(new BytesRef(), 0L, null, false, 0L, this.format);
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] + docCount;
                if (spare == null) {
                    spare = emptyBucketBuilder.get();
                }
                ordsEnum.readValue(spare.getTermBytes());
                spare.setDocCount(docCount);
                spare.setBucketOrd(ordsEnum.ord());
                spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
            }
            topBucketsPerOrd[ordIdx] = new StringTerms.Bucket[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                topBucketsPerOrd[ordIdx][i] = (StringTerms.Bucket)ordered.pop();
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][i].getDocCount();
                topBucketsPerOrd[ordIdx][i].setTermBytes(BytesRef.deepCopyOf((BytesRef)topBucketsPerOrd[ordIdx][i].getTermBytes()));
            }
        }
        this.buildSubAggsForAllBuckets(topBucketsPerOrd, InternalTerms.Bucket::getBucketOrd, InternalTerms.Bucket::setAggregations);
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBucketsPerOrd[ordIdx], reduceOrder.comparator());
            } else {
                reduceOrder = this.order;
            }
            result[ordIdx] = new StringTerms(this.name, reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), false, otherDocCounts[ordIdx], Arrays.asList(topBucketsPerOrd[ordIdx]), null);
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringTerms(this.name, this.order, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), false, 0L, Collections.emptyList(), (Long)0L);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("total_buckets", this.bucketOrds.size());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

