/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Types;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.GlobalOrdinalValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;

final class CompositeValuesCollectorQueue
extends PriorityQueue<Integer>
implements Releasable {
    private static final int CANDIDATE_SLOT = Integer.MAX_VALUE;
    private final BigArrays bigArrays;
    private final int maxSize;
    private final Map<Slot, Integer> map;
    private final SingleDimensionValuesSource<?>[] arrays;
    private final CompetitiveBoundsChangedListener competitiveBoundsChangedListener;
    private LongArray docCounts;
    private boolean afterKeyIsSet = false;

    CompositeValuesCollectorQueue(BigArrays bigArrays, SingleDimensionValuesSource<?>[] sources, int size, IndexReader indexReader) {
        super(size);
        this.bigArrays = bigArrays;
        this.maxSize = size;
        this.arrays = sources;
        SingleDimensionValuesSource<?> singleDimensionValuesSource = this.arrays[0];
        if (singleDimensionValuesSource instanceof GlobalOrdinalValuesSource) {
            GlobalOrdinalValuesSource globalOrdinalValuesSource = (GlobalOrdinalValuesSource)singleDimensionValuesSource;
            this.competitiveBoundsChangedListener = CompositeValuesCollectorQueue.shouldApplyGlobalOrdinalDynamicPruningForLeadingSource(sources, size, indexReader) ? globalOrdinalValuesSource::updateHighestCompetitiveValue : null;
        } else {
            this.competitiveBoundsChangedListener = null;
        }
        this.map = Maps.newMapWithExpectedSize(size);
        this.docCounts = bigArrays.newLongArray(1L, false);
    }

    private static boolean shouldApplyGlobalOrdinalDynamicPruningForLeadingSource(SingleDimensionValuesSource<?>[] sources, int size, IndexReader indexReader) {
        if (sources.length == 0) {
            return false;
        }
        SingleDimensionValuesSource<?> singleDimensionValuesSource = sources[0];
        if (singleDimensionValuesSource instanceof GlobalOrdinalValuesSource) {
            GlobalOrdinalValuesSource firstSource = (GlobalOrdinalValuesSource)singleDimensionValuesSource;
            if (!firstSource.mayDynamicallyPrune(indexReader)) {
                return false;
            }
            long approximateTotalNumberOfBuckets = firstSource.getUniqueValueCount();
            if (sources.length > 1) {
                approximateTotalNumberOfBuckets *= 3L;
            }
            if ((long)size >= approximateTotalNumberOfBuckets / 8L) {
                return false;
            }
            long rangeWidthPerPage = size + size / 4;
            if (sources.length > 1) {
                rangeWidthPerPage /= 3L;
            }
            return rangeWidthPerPage <= 128L;
        }
        return false;
    }

    public boolean mayDynamicallyPrune() {
        return this.competitiveBoundsChangedListener != null;
    }

    public void setAfterKey(CompositeKey afterKey) {
        assert (afterKey.size() == this.arrays.length);
        this.afterKeyIsSet = true;
        for (int i = 0; i < afterKey.size(); ++i) {
            try {
                this.arrays[i].setAfter(afterKey.get(i));
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("incompatible value in the position " + i + ": " + ex.getMessage(), ex);
            }
        }
    }

    protected boolean lessThan(Integer a, Integer b) {
        return this.compare(a, b) > 0;
    }

    boolean isFull() {
        return this.size() >= this.maxSize;
    }

    Integer compareCurrent() {
        return this.map.get(new Slot(Integer.MAX_VALUE));
    }

    Comparable<?> getLowerValueLeadSource() {
        return this.afterKeyIsSet ? (Comparable<?>)this.arrays[0].getAfter() : null;
    }

    Comparable<?> getUpperValueLeadSource() throws IOException {
        return this.size() >= this.maxSize ? (Comparable<?>)this.arrays[0].toComparable((Integer)this.top()) : null;
    }

    long getDocCount(int slot) {
        return this.docCounts.get(slot);
    }

    private void copyCurrent(int slot, long value) {
        for (SingleDimensionValuesSource<?> array : this.arrays) {
            array.copyCurrent(slot);
        }
        this.docCounts = this.bigArrays.grow(this.docCounts, (long)(slot + 1));
        this.docCounts.set(slot, value);
    }

    int compare(int slot1, int slot2) {
        assert (slot2 != Integer.MAX_VALUE);
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = slot1 == Integer.MAX_VALUE ? this.arrays[i].compareCurrent(slot2) : this.arrays[i].compare(slot1, slot2);
            if (cmp == 0) continue;
            return cmp > 0 ? i + 1 : -(i + 1);
        }
        return 0;
    }

    boolean equals(int slot1, int slot2) {
        assert (slot2 != Integer.MAX_VALUE);
        for (SingleDimensionValuesSource<?> array : this.arrays) {
            int cmp = slot1 == Integer.MAX_VALUE ? array.compareCurrent(slot2) : array.compare(slot1, slot2);
            if (cmp == 0) continue;
            return false;
        }
        return true;
    }

    int hashCode(int slot) {
        int result = 1;
        for (SingleDimensionValuesSource<?> array : this.arrays) {
            result = 31 * result + (slot == Integer.MAX_VALUE ? array.hashCodeCurrent() : array.hashCode(slot));
        }
        return result;
    }

    private int compareCurrentWithAfter() {
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = this.arrays[i].compareCurrentWithAfter();
            if (cmp == 0) continue;
            return cmp > 0 ? i + 1 : -(i + 1);
        }
        return 0;
    }

    CompositeKey toCompositeKey(int slot) throws IOException {
        assert (slot < this.maxSize);
        Comparable[] values = new Comparable[this.arrays.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.arrays[i].toComparable(slot);
        }
        return new CompositeKey(values);
    }

    LeafBucketCollector getLeafCollector(LeafReaderContext context, LeafBucketCollector in) throws IOException {
        LeafBucketCollector leafBucketCollector = this.getLeafCollector(null, context, in);
        if (this.competitiveBoundsChangedListener != null && this.size() >= this.maxSize) {
            this.competitiveBoundsChangedListener.boundsChanged((Integer)this.top());
        }
        return leafBucketCollector;
    }

    LeafBucketCollector getLeafCollector(Comparable<?> forceLeadSourceValue, LeafReaderContext context, LeafBucketCollector in) throws IOException {
        int last = this.arrays.length - 1;
        LeafBucketCollector collector = in;
        while (last > 0) {
            collector = this.arrays[last--].getLeafCollector(context, collector);
        }
        collector = forceLeadSourceValue != null ? this.arrays[last].getLeafCollector((Comparable)Types.forciblyCast(forceLeadSourceValue), context, collector) : this.arrays[last].getLeafCollector(context, collector);
        return collector;
    }

    boolean addIfCompetitive(long inc) throws IOException {
        return this.addIfCompetitive(0, inc);
    }

    boolean addIfCompetitive(int indexSortSourcePrefix, long inc) throws IOException {
        int newSlot;
        int cmp;
        Integer topSlot = this.compareCurrent();
        if (topSlot != null) {
            this.docCounts.increment(topSlot.intValue(), inc);
            return true;
        }
        if (this.afterKeyIsSet && (cmp = this.compareCurrentWithAfter()) <= 0) {
            if (indexSortSourcePrefix < 0 && cmp == indexSortSourcePrefix) {
                throw new CollectionTerminatedException();
            }
            return false;
        }
        if (this.size() >= this.maxSize && (cmp = this.compare(Integer.MAX_VALUE, (Integer)this.top())) > 0) {
            if (cmp <= indexSortSourcePrefix) {
                throw new CollectionTerminatedException();
            }
            return false;
        }
        if (this.size() >= this.maxSize) {
            int slot = (Integer)this.pop();
            this.map.remove(new Slot(slot));
            newSlot = slot;
        } else {
            newSlot = this.size();
        }
        this.copyCurrent(newSlot, inc);
        this.map.put(new Slot(newSlot), newSlot);
        this.add(newSlot);
        if (this.competitiveBoundsChangedListener != null && this.size() >= this.maxSize) {
            this.competitiveBoundsChangedListener.boundsChanged((Integer)this.top());
        }
        return true;
    }

    public void close() {
        Releasables.close((Releasable)this.docCounts);
    }

    @FunctionalInterface
    private static interface CompetitiveBoundsChangedListener {
        public void boundsChanged(int var1) throws IOException;
    }

    private class Slot {
        final int value;

        Slot(int initial) {
            this.value = initial;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Slot slot = (Slot)o;
            return CompositeValuesCollectorQueue.this.equals(this.value, slot.value);
        }

        public int hashCode() {
            return CompositeValuesCollectorQueue.this.hashCode(this.value);
        }
    }
}

