/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
implements RestHandler {
    public static final String INCLUDE_TYPE_NAME_PARAMETER = "include_type_name";
    public static final boolean DEFAULT_INCLUDE_TYPE_NAME_POLICY = false;
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);
    private final LongAdder usageCount = new LongAdder();

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    public abstract String getName();

    @Override
    public abstract List<RestHandler.Route> routes();

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestChannelConsumer action = this.prepareRequest(request, client);
        SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams(request.getRestApiVersion()).contains(p)).collect(Collectors.toCollection(TreeSet::new));
        if (!unconsumedParams.isEmpty()) {
            HashSet<String> candidateParams = new HashSet<String>();
            candidateParams.addAll(request.consumedParams());
            candidateParams.addAll(this.responseParams(request.getRestApiVersion()));
            throw new IllegalArgumentException(BaseRestHandler.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
        }
        if (request.hasContent() && !request.isContentConsumed()) {
            throw new IllegalArgumentException("request [" + request.method() + " " + request.path() + "] does not support having a body");
        }
        this.usageCount.increment();
        action.accept(channel);
    }

    protected static String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder(String.format(Locale.ROOT, "request [%s] contains unrecognized %s%s: ", request.path(), detail, invalids.size() > 1 ? "s" : ""));
        boolean first = true;
        for (String invalid : invalids) {
            LevenshteinDistance ld = new LevenshteinDistance();
            ArrayList<Tuple> scoredParams = new ArrayList<Tuple>();
            for (String candidate : candidates) {
                float distance = ld.getDistance(invalid, candidate);
                if (!(distance > 0.5f)) continue;
                scoredParams.add(new Tuple((Object)Float.valueOf(distance), (Object)candidate));
            }
            CollectionUtil.timSort(scoredParams, (a, b) -> {
                int compare = ((Float)a.v1()).compareTo((Float)b.v1());
                if (compare != 0) {
                    return -compare;
                }
                return ((String)a.v2()).compareTo((String)b.v2());
            });
            if (!first) {
                message.append(", ");
            }
            message.append("[").append(invalid).append("]");
            List<String> keys = scoredParams.stream().map(Tuple::v2).toList();
            if (!keys.isEmpty()) {
                message.append(" -> did you mean ");
                if (keys.size() == 1) {
                    message.append("[").append(keys.get(0)).append("]");
                } else {
                    message.append("any of ").append(keys.toString());
                }
                message.append("?");
            }
            first = false;
        }
        return message.toString();
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    protected Set<String> responseParams(RestApiVersion restApiVersion) {
        return this.responseParams();
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception> {
    }
}

