/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.plugins.PluginDescriptor;

public class PluginBundle {
    public final PluginDescriptor plugin;
    private final Path dir;
    public final Set<URL> urls;
    public final Set<URL> spiUrls;
    public final Set<URL> allUrls;

    PluginBundle(PluginDescriptor plugin, Path dir) throws IOException {
        this.plugin = Objects.requireNonNull(plugin);
        this.dir = dir;
        Path spiDir = dir.resolve("spi");
        this.spiUrls = Files.exists(spiDir, new LinkOption[0]) ? PluginBundle.gatherUrls(spiDir) : null;
        this.urls = PluginBundle.gatherUrls(dir);
        LinkedHashSet<URL> allUrls = new LinkedHashSet<URL>(this.urls);
        if (this.spiUrls != null) {
            allUrls.addAll(this.spiUrls);
        }
        this.allUrls = allUrls;
    }

    public Path getDir() {
        return this.dir;
    }

    public PluginDescriptor pluginDescriptor() {
        return this.plugin;
    }

    static Set<URL> gatherUrls(Path dir) throws IOException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(dir, "*.jar");){
            for (Path jar : jarStream) {
                URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                if (urls.add(url)) continue;
                throw new IllegalStateException("duplicate codebase: " + url);
            }
        }
        return urls;
    }

    boolean hasSPI() {
        return this.spiUrls != null;
    }

    Set<URL> getExtensionUrls() {
        if (this.spiUrls != null) {
            return this.spiUrls;
        }
        return this.urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginBundle bundle = (PluginBundle)o;
        return Objects.equals(this.plugin, bundle.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.plugin);
    }
}

