/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListShardStoreMetadata
extends TransportNodesAction<Request, NodesStoreFilesMetadata, NodeRequest, NodeStoreFilesMetadata> {
    private static final Logger logger = LogManager.getLogger(TransportNodesListShardStoreMetadata.class);
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    public static final ActionType<NodesStoreFilesMetadata> TYPE = new ActionType("internal:cluster/nodes/indices/shard/store", Writeable.Reader.localOnly());
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetadata(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters) {
        super(ACTION_NAME, clusterService, transportService, actionFilters, NodeRequest::new, threadPool.executor("fetch_shard_store"));
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeStoreFilesMetadata newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        NodeStoreFilesMetadata nodeStoreFilesMetadata = new NodeStoreFilesMetadata(in, node);
        assert (nodeStoreFilesMetadata.getNode() == node);
        return nodeStoreFilesMetadata;
    }

    @Override
    protected NodesStoreFilesMetadata newResponse(Request request, List<NodeStoreFilesMetadata> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetadata(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetadata nodeOperation(NodeRequest request, Task task) {
        try {
            return new NodeStoreFilesMetadata(this.clusterService.localNode(), this.listStoreMetadata(request));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to list store metadata for shard [" + request.shardId + "]", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private StoreFilesMetadata listStoreMetadata(NodeRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object lambda$listStoreMetadata$1(ShardId shardId) {
        return "[" + shardId + "] can't read metadata from store, responding with empty";
    }

    private static /* synthetic */ Object lambda$listStoreMetadata$0(ShardId shardId) {
        return "[" + shardId + "] node is missing index, responding with empty";
    }

    public static class NodeRequest
    extends TransportRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            assert (this.customDataPath != null);
            out.writeString(this.customDataPath);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }
    }

    public static class NodeStoreFilesMetadata
    extends BaseNodeResponse {
        private final StoreFilesMetadata storeFilesMetadata;

        public NodeStoreFilesMetadata(StreamInput in, DiscoveryNode node) throws IOException {
            super(in, node);
            this.storeFilesMetadata = StoreFilesMetadata.readFrom(in);
        }

        public NodeStoreFilesMetadata(DiscoveryNode node, StoreFilesMetadata storeFilesMetadata) {
            super(node);
            this.storeFilesMetadata = storeFilesMetadata;
        }

        public StoreFilesMetadata storeFilesMetadata() {
            return this.storeFilesMetadata;
        }

        public static NodeStoreFilesMetadata readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            return new NodeStoreFilesMetadata(in, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetadata.writeTo(out);
        }

        public String toString() {
            return "[[" + this.getNode() + "][" + this.storeFilesMetadata + "]]";
        }
    }

    public static class NodesStoreFilesMetadata
    extends BaseNodesResponse<NodeStoreFilesMetadata> {
        public NodesStoreFilesMetadata(ClusterName clusterName, List<NodeStoreFilesMetadata> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetadata> readNodesFrom(StreamInput in) throws IOException {
            return (List)TransportAction.localOnly();
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetadata> nodes) throws IOException {
            TransportAction.localOnly();
        }
    }

    public record StoreFilesMetadata(Store.MetadataSnapshot metadataSnapshot, List<RetentionLease> peerRecoveryRetentionLeases) implements Iterable<StoreFileMetadata>,
    Writeable
    {
        private static final ShardId FAKE_SHARD_ID = new ShardId("_na_", "_na_", 0);
        public static final StoreFilesMetadata EMPTY = new StoreFilesMetadata(Store.MetadataSnapshot.EMPTY, Collections.emptyList());

        public static StoreFilesMetadata readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().before(TransportVersions.V_8_2_0)) {
                new ShardId(in);
            }
            Store.MetadataSnapshot metadataSnapshot = Store.MetadataSnapshot.readFrom(in);
            List<RetentionLease> peerRecoveryRetentionLeases = in.readCollectionAsImmutableList(RetentionLease::new);
            if (metadataSnapshot == Store.MetadataSnapshot.EMPTY && peerRecoveryRetentionLeases.isEmpty()) {
                return EMPTY;
            }
            return new StoreFilesMetadata(metadataSnapshot, peerRecoveryRetentionLeases);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().before(TransportVersions.V_8_2_0)) {
                FAKE_SHARD_ID.writeTo(out);
                assert (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) : out.getTransportVersion();
            }
            this.metadataSnapshot.writeTo(out);
            out.writeCollection(this.peerRecoveryRetentionLeases);
        }

        public boolean isEmpty() {
            return this.metadataSnapshot.size() == 0;
        }

        @Override
        public Iterator<StoreFileMetadata> iterator() {
            return this.metadataSnapshot.iterator();
        }

        public boolean fileExists(String name) {
            return this.metadataSnapshot.fileMetadataMap().containsKey(name);
        }

        public StoreFileMetadata file(String name) {
            return this.metadataSnapshot.fileMetadataMap().get(name);
        }

        public long getPeerRecoveryRetentionLeaseRetainingSeqNo(DiscoveryNode node) {
            assert (node != null);
            String retentionLeaseId = ReplicationTracker.getPeerRecoveryRetentionLeaseId(node.getId());
            return this.peerRecoveryRetentionLeases.stream().filter(lease -> lease.id().equals(retentionLeaseId)).mapToLong(RetentionLease::retainingSequenceNumber).findFirst().orElse(-1L);
        }

        public String syncId() {
            return this.metadataSnapshot.getSyncId();
        }

        @Override
        public String toString() {
            return "StoreFilesMetadata{, metadataSnapshot{size=" + this.metadataSnapshot.size() + ", syncId=" + this.metadataSnapshot.getSyncId() + "}}";
        }
    }
}

