/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class PeerRecoverySourceClusterStateDelay {
    private static final Logger logger = LogManager.getLogger(PeerRecoverySourceClusterStateDelay.class);

    private PeerRecoverySourceClusterStateDelay() {
    }

    public static <T> void ensureClusterStateVersion(final long clusterStateVersion, ClusterService clusterService, Executor executor, ThreadContext threadContext, ActionListener<T> listener, final Consumer<ActionListener<T>> proceedWithRecovery) {
        if (clusterStateVersion <= clusterService.state().version()) {
            proceedWithRecovery.accept(listener);
        } else {
            logger.debug("delaying {} until application of cluster state version {}", new Object[]{proceedWithRecovery, clusterStateVersion});
            final SubscribableListener<Object> waitListener = new SubscribableListener<Object>();
            ClusterStateListener clusterStateVersionListener = new ClusterStateListener(){

                @Override
                public void clusterChanged(ClusterChangedEvent event) {
                    if (clusterStateVersion <= event.state().version()) {
                        waitListener.onResponse(null);
                    }
                }

                public String toString() {
                    return "ClusterStateListener for " + proceedWithRecovery;
                }
            };
            clusterService.addListener(clusterStateVersionListener);
            waitListener.addListener(ActionListener.running(() -> PeerRecoverySourceClusterStateDelay.lambda$ensureClusterStateVersion$0(clusterService, clusterStateVersionListener)));
            if (clusterStateVersion <= clusterService.state().version()) {
                waitListener.onResponse((Object)null);
            }
            waitListener.addListener(listener.delegateFailureAndWrap((l, ignored) -> proceedWithRecovery.accept((ActionListener)l)), executor, threadContext);
        }
    }

    private static /* synthetic */ void lambda$ensureClusterStateVersion$0(ClusterService clusterService, 1 clusterStateVersionListener) {
        clusterService.removeListener(clusterStateVersionListener);
    }
}

