/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.classic.ClassicAnalyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PreBuiltAnalyzers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.INDEX){

        @Override
        protected Analyzer create(IndexVersion version) {
            return new StandardAnalyzer(CharArraySet.EMPTY_SET);
        }
    }
    ,
    DEFAULT(PreBuiltCacheFactory.CachingStrategy.INDEX){

        @Override
        protected Analyzer create(IndexVersion version) {
            return STANDARD.getAnalyzer(version);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(IndexVersion version) {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer create(IndexVersion version) {
            return new StopAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer create(IndexVersion version) {
            return new WhitespaceAnalyzer();
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer create(IndexVersion version) {
            return new SimpleAnalyzer();
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer create(IndexVersion version) {
            return new ClassicAnalyzer();
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<Analyzer> cache;

    protected abstract Analyzer create(IndexVersion var1);

    private PreBuiltAnalyzers() {
        this(PreBuiltCacheFactory.CachingStrategy.LUCENE);
    }

    private PreBuiltAnalyzers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public PreBuiltCacheFactory.PreBuiltCache<Analyzer> getCache() {
        return this.cache;
    }

    public synchronized Analyzer getAnalyzer(IndexVersion version) {
        Analyzer analyzer = this.cache.get(version);
        if (analyzer == null) {
            analyzer = this.create(version);
            this.cache.put(version, analyzer);
        }
        return analyzer;
    }

    public static PreBuiltAnalyzers getOrDefault(String name, PreBuiltAnalyzers defaultAnalyzer) {
        try {
            return PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultAnalyzer;
        }
    }
}

