/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.translog.Translog;

public final class RefreshListeners
implements ReferenceManager.RefreshListener,
Closeable {
    private final IntSupplier getMaxRefreshListeners;
    private final Runnable forceRefresh;
    private final Logger logger;
    private final ThreadContext threadContext;
    private final MeanMetric refreshMetric;
    private long currentRefreshStartTime;
    private volatile boolean closed = false;
    private int refreshForcers;
    private volatile List<Tuple<Translog.Location, Consumer<Boolean>>> locationRefreshListeners = null;
    private volatile List<Tuple<Long, ActionListener<Void>>> checkpointRefreshListeners = null;
    private volatile Translog.Location lastRefreshedLocation;
    private volatile long lastRefreshedCheckpoint = -1L;
    private Translog.Location currentRefreshLocation;
    private Supplier<Translog.Location> currentRefreshLocationSupplier;
    private long currentRefreshCheckpoint;
    private LongSupplier processedCheckpointSupplier;
    private LongSupplier maxIssuedSeqNoSupplier;

    public RefreshListeners(IntSupplier getMaxRefreshListeners, Runnable forceRefresh, Logger logger, ThreadContext threadContext, MeanMetric refreshMetric) {
        this.getMaxRefreshListeners = getMaxRefreshListeners;
        this.forceRefresh = forceRefresh;
        this.logger = logger;
        this.threadContext = threadContext;
        this.refreshMetric = refreshMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Releasable forceRefreshes() {
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            assert (this.refreshForcers >= 0);
            ++this.refreshForcers;
        }
        Releasable releaseOnce = Releasables.releaseOnce(() -> {
            RefreshListeners refreshListeners = this;
            synchronized (refreshListeners) {
                assert (this.refreshForcers > 0);
                --this.refreshForcers;
            }
        });
        if (this.refreshNeeded()) {
            try {
                this.forceRefresh.run();
            }
            catch (Exception e) {
                releaseOnce.close();
                throw e;
            }
        }
        assert (this.locationRefreshListeners == null);
        assert (this.checkpointRefreshListeners == null);
        return releaseOnce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(Translog.Location location, Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        if (this.lastRefreshedLocation != null && this.lastRefreshedLocation.compareTo(location) >= 0) {
            listener.accept(false);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            if (this.closed) {
                throw new IllegalStateException("can't wait for refresh on a closed index");
            }
            List<Tuple<Translog.Location, Consumer<Boolean>>> listeners = this.locationRefreshListeners;
            int maxRefreshes = this.getMaxRefreshListeners.getAsInt();
            if (this.refreshForcers == 0 && RefreshListeners.roomForListener(maxRefreshes, listeners, this.checkpointRefreshListeners)) {
                ThreadContext.StoredContext storedContext = this.threadContext.newStoredContextPreservingResponseHeaders();
                Consumer<Boolean> contextPreservingListener = forced -> {
                    try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
                        storedContext.restore();
                        listener.accept((Boolean)forced);
                    }
                };
                if (listeners == null) {
                    listeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                listeners.add((Tuple<Translog.Location, Consumer<Boolean>>)new Tuple((Object)location, contextPreservingListener));
                this.locationRefreshListeners = listeners;
                return false;
            }
        }
        this.forceRefresh.run();
        listener.accept(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(long checkpoint, boolean allowUnIssuedSequenceNumber, ActionListener<Void> listener) {
        long maxIssuedSequenceNumber;
        assert (checkpoint >= -1L);
        if (checkpoint <= this.lastRefreshedCheckpoint) {
            listener.onResponse(null);
            return true;
        }
        if (!allowUnIssuedSequenceNumber && checkpoint > (maxIssuedSequenceNumber = this.maxIssuedSeqNoSupplier.getAsLong())) {
            IllegalArgumentException e = new IllegalArgumentException("Cannot wait for unissued seqNo checkpoint [wait_for_checkpoint=" + checkpoint + ", max_issued_seqNo=" + maxIssuedSequenceNumber + "]");
            listener.onFailure(e);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            if (this.closed) {
                listener.onFailure(new IllegalStateException("can't wait for refresh on a closed index"));
                return true;
            }
            List<Tuple<Long, ActionListener<Void>>> listeners = this.checkpointRefreshListeners;
            int maxRefreshes = this.getMaxRefreshListeners.getAsInt();
            if (RefreshListeners.roomForListener(maxRefreshes, this.locationRefreshListeners, listeners)) {
                this.addCheckpointListener(checkpoint, listener, listeners);
                return false;
            }
        }
        listener.onFailure(new IllegalStateException("Too many listeners waiting on refresh, wait listener rejected."));
        return true;
    }

    private void addCheckpointListener(long checkpoint, ActionListener<Void> listener, List<Tuple<Long, ActionListener<Void>>> listeners) {
        assert (Thread.holdsLock(this));
        ContextPreservingActionListener<Void> contextPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, this.threadContext);
        if (listeners == null) {
            listeners = new ArrayList<Tuple<Long, ActionListener<Void>>>();
        }
        listeners.add((Tuple<Long, ActionListener<Void>>)new Tuple((Object)checkpoint, contextPreservingListener));
        this.checkpointRefreshListeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<Tuple<Long, ActionListener<Void>>> oldCheckpointListeners;
        List<Tuple<Translog.Location, Consumer<Boolean>>> oldLocationListeners;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            oldLocationListeners = this.locationRefreshListeners;
            this.locationRefreshListeners = null;
            oldCheckpointListeners = this.checkpointRefreshListeners;
            this.checkpointRefreshListeners = null;
            this.closed = true;
        }
        this.fireListeners(oldLocationListeners);
        this.failCheckpointListeners(oldCheckpointListeners, (Exception)((Object)new AlreadyClosedException("shard is closed")));
    }

    public boolean refreshNeeded() {
        return (this.locationRefreshListeners != null || this.checkpointRefreshListeners != null) && false == this.closed;
    }

    public synchronized int pendingCount() {
        List<Tuple<Translog.Location, Consumer<Boolean>>> locationListeners = this.locationRefreshListeners;
        List<Tuple<Long, ActionListener<Void>>> checkpointListeners = this.checkpointRefreshListeners;
        return (locationListeners == null ? 0 : locationListeners.size()) + (checkpointListeners == null ? 0 : checkpointListeners.size());
    }

    public void setCurrentRefreshLocationSupplier(Supplier<Translog.Location> currentRefreshLocationSupplier) {
        this.currentRefreshLocationSupplier = currentRefreshLocationSupplier;
    }

    public void setCurrentProcessedCheckpointSupplier(LongSupplier processedCheckpointSupplier) {
        this.processedCheckpointSupplier = processedCheckpointSupplier;
    }

    public void setMaxIssuedSeqNoSupplier(LongSupplier maxIssuedSeqNoSupplier) {
        this.maxIssuedSeqNoSupplier = maxIssuedSeqNoSupplier;
    }

    public void beforeRefresh() throws IOException {
        this.currentRefreshLocation = this.currentRefreshLocationSupplier.get();
        this.currentRefreshCheckpoint = this.processedCheckpointSupplier.getAsLong();
        this.currentRefreshStartTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) throws IOException {
        List<Tuple<Long, ActionListener<Void>>> checkpointCandidates;
        List<Tuple<Translog.Location, Consumer<Boolean>>> locationCandidates;
        this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        this.lastRefreshedLocation = this.currentRefreshLocation;
        this.lastRefreshedCheckpoint = this.currentRefreshCheckpoint;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            locationCandidates = this.locationRefreshListeners;
            checkpointCandidates = this.checkpointRefreshListeners;
            if (locationCandidates == null && checkpointCandidates == null) {
                return;
            }
            this.locationRefreshListeners = null;
            this.checkpointRefreshListeners = null;
        }
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> locationListenersToFire = null;
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> preservedLocationListeners = null;
        if (locationCandidates != null) {
            for (Tuple<Translog.Location, Consumer<Boolean>> tuple : locationCandidates) {
                Translog.Location location = (Translog.Location)tuple.v1();
                if (location.compareTo(this.currentRefreshLocation) <= 0) {
                    if (locationListenersToFire == null) {
                        locationListenersToFire = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                    }
                    locationListenersToFire.add(tuple);
                    continue;
                }
                if (preservedLocationListeners == null) {
                    preservedLocationListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                preservedLocationListeners.add(tuple);
            }
        }
        ArrayList<Tuple<Long, ActionListener<Void>>> checkpointListenersToFire = null;
        ArrayList<Tuple<Long, ActionListener<Void>>> preservedCheckpointListeners = null;
        if (checkpointCandidates != null) {
            for (Tuple<Long, ActionListener<Void>> tuple : checkpointCandidates) {
                long checkpoint = (Long)tuple.v1();
                if (checkpoint <= this.currentRefreshCheckpoint) {
                    if (checkpointListenersToFire == null) {
                        checkpointListenersToFire = new ArrayList<Tuple<Long, ActionListener<Void>>>();
                    }
                    checkpointListenersToFire.add(tuple);
                    continue;
                }
                if (preservedCheckpointListeners == null) {
                    preservedCheckpointListeners = new ArrayList<Tuple<Long, ActionListener<Void>>>();
                }
                preservedCheckpointListeners.add(tuple);
            }
        }
        ArrayList checkpointListenersToFail = null;
        if (preservedLocationListeners != null || preservedCheckpointListeners != null) {
            RefreshListeners refreshListeners2 = this;
            synchronized (refreshListeners2) {
                if (preservedLocationListeners != null) {
                    if (this.locationRefreshListeners == null) {
                        if (this.closed) {
                            if (locationListenersToFire == null) {
                                locationListenersToFire = new ArrayList();
                            }
                            locationListenersToFire.addAll(preservedLocationListeners);
                        } else {
                            this.locationRefreshListeners = preservedLocationListeners;
                        }
                    } else {
                        assert (!this.closed) : "Can't be closed and have non-null refreshListeners";
                        this.locationRefreshListeners.addAll(preservedLocationListeners);
                    }
                }
                if (preservedCheckpointListeners != null) {
                    if (this.checkpointRefreshListeners == null) {
                        if (this.closed) {
                            checkpointListenersToFail = new ArrayList(preservedCheckpointListeners);
                        } else {
                            this.checkpointRefreshListeners = preservedCheckpointListeners;
                        }
                    } else {
                        assert (!this.closed) : "Can't be closed and have non-null refreshListeners";
                        this.checkpointRefreshListeners.addAll(preservedCheckpointListeners);
                    }
                }
            }
        }
        this.fireListeners(locationListenersToFire);
        this.fireCheckpointListeners(checkpointListenersToFire);
        this.failCheckpointListeners(checkpointListenersToFail, (Exception)((Object)new AlreadyClosedException("shard is closed")));
    }

    private void fireListeners(List<Tuple<Translog.Location, Consumer<Boolean>>> listenersToFire) {
        if (listenersToFire != null) {
            for (Tuple<Translog.Location, Consumer<Boolean>> listener : listenersToFire) {
                try {
                    ((Consumer)listener.v2()).accept(false);
                }
                catch (Exception e) {
                    this.logger.warn("error firing location refresh listener", (Throwable)e);
                }
            }
        }
    }

    private static boolean roomForListener(int maxRefreshes, List<Tuple<Translog.Location, Consumer<Boolean>>> locationListeners, List<Tuple<Long, ActionListener<Void>>> checkpointListeners) {
        int locationListenerCount = locationListeners == null ? 0 : locationListeners.size();
        int checkpointListenerCount = checkpointListeners == null ? 0 : checkpointListeners.size();
        return locationListenerCount + checkpointListenerCount < maxRefreshes;
    }

    private void fireCheckpointListeners(List<Tuple<Long, ActionListener<Void>>> listenersToFire) {
        if (listenersToFire != null) {
            for (Tuple<Long, ActionListener<Void>> listener : listenersToFire) {
                try {
                    ((ActionListener)listener.v2()).onResponse(null);
                }
                catch (Exception e) {
                    this.logger.warn("error firing checkpoint refresh listener", (Throwable)e);
                    assert (false);
                }
            }
        }
    }

    private void failCheckpointListeners(List<Tuple<Long, ActionListener<Void>>> listenersToFire, Exception exception) {
        if (listenersToFire != null) {
            for (Tuple<Long, ActionListener<Void>> listener : listenersToFire) {
                try {
                    ((ActionListener)listener.v2()).onFailure(exception);
                }
                catch (Exception e) {
                    this.logger.warn("error firing checkpoint refresh listener", (Throwable)e);
                    assert (false);
                }
            }
        }
    }
}

