/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldBlockLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentType;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    private static final SourceFieldMapper DEFAULT = new SourceFieldMapper(null, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, null);
    private static final SourceFieldMapper TSDB_DEFAULT = new SourceFieldMapper(Mode.SYNTHETIC, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, IndexMode.TIME_SERIES);
    private static final SourceFieldMapper TSDB_LEGACY_DEFAULT = new SourceFieldMapper(null, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, IndexMode.TIME_SERIES);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> c.getIndexSettings().getMode() == IndexMode.TIME_SERIES ? (c.getIndexSettings().getIndexVersionCreated().onOrAfter(IndexVersions.V_8_7_0) ? TSDB_DEFAULT : TSDB_LEGACY_DEFAULT) : DEFAULT, c -> new Builder(c.getIndexSettings().getMode()));
    @Nullable
    private final Mode mode;
    private final Explicit<Boolean> enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;
    private final SourceFilter sourceFilter;
    private final IndexMode indexMode;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private SourceFieldMapper(Mode mode, Explicit<Boolean> enabled, String[] includes, String[] excludes, IndexMode indexMode) {
        super(new SourceFieldType(enabled.explicit() && enabled.value() != false || !enabled.explicit() && mode != Mode.DISABLED));
        assert (!enabled.explicit() || mode == null);
        this.mode = mode;
        this.enabled = enabled;
        this.sourceFilter = SourceFieldMapper.buildSourceFilter(includes, excludes);
        this.includes = includes;
        this.excludes = excludes;
        if (this.sourceFilter != null && (mode == Mode.SYNTHETIC || indexMode == IndexMode.TIME_SERIES)) {
            throw new IllegalArgumentException("filtering the stored _source is incompatible with synthetic source");
        }
        this.complete = this.stored() && this.sourceFilter == null;
        this.indexMode = indexMode;
    }

    private static SourceFilter buildSourceFilter(String[] includes, String[] excludes) {
        if (CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes)) {
            return null;
        }
        return new SourceFilter(includes, excludes);
    }

    private boolean stored() {
        if (this.enabled.explicit() || this.mode == null) {
            return this.enabled.value();
        }
        return this.mode == Mode.STORED;
    }

    public boolean enabled() {
        if (this.enabled.explicit()) {
            return this.enabled.value();
        }
        if (this.mode != null) {
            return this.mode != Mode.DISABLED;
        }
        return this.enabled.value();
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(DocumentParserContext context) throws IOException {
        BytesRef ref;
        XContentType contentType;
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference adaptedSource = this.applyFilters(originalSource, contentType = context.sourceToParse().getXContentType());
        if (adaptedSource != null) {
            ref = adaptedSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if (originalSource != null && adaptedSource != originalSource) {
            ref = originalSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Nullable
    public BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable XContentType contentType) throws IOException {
        if (!this.stored()) {
            return null;
        }
        if (originalSource != null && this.sourceFilter != null) {
            return Source.fromBytes(originalSource, contentType).filter(this.sourceFilter).internalSourceRef();
        }
        return originalSource;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.indexMode).init(this);
    }

    public SourceLoader newSourceLoader(Mapping mapping) {
        if (this.mode == Mode.SYNTHETIC) {
            return new SourceLoader.Synthetic(mapping);
        }
        return SourceLoader.FROM_STORED_SOURCE;
    }

    public boolean isSynthetic() {
        return this.mode == Mode.SYNTHETIC;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    static final class SourceFieldType
    extends MappedFieldType {
        private final boolean enabled;

        private SourceFieldType(boolean enabled) {
            super("_source", false, enabled, false, TextSearchInfo.NONE, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.enabled) {
                return new SourceFieldBlockLoader();
            }
            return BlockLoader.CONSTANT_NULLS;
        }
    }

    private static enum Mode {
        DISABLED,
        STORED,
        SYNTHETIC;

    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = FieldMapper.Parameter.explicitBoolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true).setSerializerCheck((includeDefaults, isConfigured, value) -> value.explicit()).setMergeValidator((previous, current, conflicts) -> previous.value() == current.value() || (Boolean)previous.value() != false && (Boolean)current.value() == false);
        private final FieldMapper.Parameter<Mode> mode = new FieldMapper.Parameter<Mode>("mode", true, () -> null, (n, c, o) -> Mode.valueOf(o.toString().toUpperCase(Locale.ROOT)), m -> SourceFieldMapper.toType((FieldMapper)m).enabled.explicit() ? null : SourceFieldMapper.toType((FieldMapper)m).mode, (b, n, v) -> b.field(n, v.toString().toLowerCase(Locale.ROOT)), v -> v.toString().toLowerCase(Locale.ROOT)).setMergeValidator((previous, current, conflicts) -> previous == current || current != Mode.STORED).setSerializerCheck((includeDefaults, isConfigured, value) -> value != null);
        private final FieldMapper.Parameter<List<String>> includes = FieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes));
        private final FieldMapper.Parameter<List<String>> excludes = FieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes));
        private final IndexMode indexMode;

        public Builder(IndexMode indexMode) {
            super("_source");
            this.indexMode = indexMode;
        }

        public Builder setSynthetic() {
            this.mode.setValue(Mode.SYNTHETIC);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled, this.mode, this.includes, this.excludes};
        }

        private boolean isDefault() {
            if (this.mode.get() != null) {
                return false;
            }
            if (!this.enabled.get().value().booleanValue()) {
                return false;
            }
            return this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty();
        }

        @Override
        public SourceFieldMapper build() {
            if (this.enabled.getValue().explicit()) {
                if (this.indexMode == IndexMode.TIME_SERIES) {
                    throw new MapperParsingException("Time series indices only support synthetic source");
                }
                if (this.mode.get() != null) {
                    throw new MapperParsingException("Cannot set both [mode] and [enabled] parameters");
                }
            }
            if (this.isDefault()) {
                return this.indexMode == IndexMode.TIME_SERIES ? TSDB_DEFAULT : DEFAULT;
            }
            SourceFieldMapper sourceFieldMapper = new SourceFieldMapper(this.mode.get(), this.enabled.get(), (String[])this.includes.getValue().toArray(String[]::new), (String[])this.excludes.getValue().toArray(String[]::new), this.indexMode);
            if (this.indexMode != null) {
                this.indexMode.validateSourceFieldMapper(sourceFieldMapper);
            }
            return sourceFieldMapper;
        }

        private IndexMode getIndexMode() {
            return this.indexMode;
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setIndexOptions(IndexOptions.NONE);
            ft.setStored(true);
            ft.setOmitNorms(true);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        }
    }
}

