/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DynamicFieldsBuilder;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ObjectMapper
extends Mapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ObjectMapper.class);
    public static final String CONTENT_TYPE = "object";
    private final String fullPath;
    protected final Explicit<Boolean> enabled;
    protected final Explicit<Boolean> subobjects;
    protected final Dynamic dynamic;
    protected final Map<String, Mapper> mappers;

    private static void validateFieldName(String fieldName, IndexVersion indexCreatedVersion) {
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        if (fieldName.isBlank() & indexCreatedVersion.onOrAfter(IndexVersions.V_8_6_0)) {
            throw new IllegalArgumentException("field name cannot contain only whitespaces");
        }
    }

    ObjectMapper(String name, String fullPath, Explicit<Boolean> enabled, Explicit<Boolean> subobjects, Dynamic dynamic, Map<String, Mapper> mappers) {
        super(name);
        assert (!name.isEmpty());
        this.fullPath = ObjectMapper.internFieldName(fullPath);
        this.enabled = enabled;
        this.subobjects = subobjects;
        this.dynamic = dynamic;
        this.mappers = mappers == null ? Map.of() : Map.copyOf(mappers);
    }

    public Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.simpleName(), this.subobjects);
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        return builder;
    }

    @Override
    public String name() {
        return this.fullPath;
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public boolean isEnabled() {
        return this.enabled.value();
    }

    public boolean isNested() {
        return false;
    }

    public Mapper getMapper(String field) {
        return this.mappers.get(field);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.mappers.values().iterator();
    }

    public String fullPath() {
        return this.fullPath;
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    public final boolean subobjects() {
        return this.subobjects.value();
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, MapperBuilderContext mapperBuilderContext) {
        return this.merge(mergeWith, MapperService.MergeReason.MAPPING_UPDATE, mapperBuilderContext);
    }

    @Override
    public void validate(MappingLookup mappers) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.validate(mappers);
        }
    }

    protected MapperBuilderContext createChildContext(MapperBuilderContext mapperBuilderContext, String name) {
        return mapperBuilderContext.createChildContext(name);
    }

    public ObjectMapper merge(Mapper mergeWith, MapperService.MergeReason reason, MapperBuilderContext parentBuilderContext) {
        MergeResult mergeResult = MergeResult.build(this, mergeWith, reason, parentBuilderContext);
        return new ObjectMapper(this.simpleName(), this.fullPath, mergeResult.enabled, mergeResult.subObjects, mergeResult.dynamic, mergeResult.mappers);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null);
        return builder;
    }

    void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        builder.startObject(this.simpleName());
        if (this.mappers.isEmpty() && custom == null) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", this.enabled.value());
        }
        if (this.subobjects != Defaults.SUBOBJECTS) {
            builder.field("subobjects", this.subobjects.value());
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        this.serializeMappers(builder, params);
        builder.endObject();
    }

    protected void serializeMappers(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Mapper[] sortedMappers = (Mapper[])this.mappers.values().toArray(Mapper[]::new);
        Arrays.sort(sortedMappers, Comparator.comparing(Mapper::name));
        int count = 0;
        for (Mapper mapper : sortedMappers) {
            if (mapper instanceof MetadataFieldMapper) continue;
            if (count++ == 0) {
                builder.startObject("properties");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader(Stream<Mapper> extra) {
        return new SyntheticSourceFieldLoader(Stream.concat(extra, this.mappers.values().stream()).sorted(Comparator.comparing(Mapper::name)).map(Mapper::syntheticFieldLoader).filter(l -> l != null).toList());
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return this.syntheticFieldLoader(Stream.empty());
    }

    protected void startSyntheticField(XContentBuilder b) throws IOException {
        b.startObject(this.simpleName());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Dynamic {
        TRUE{

            @Override
            DynamicFieldsBuilder getDynamicFieldsBuilder() {
                return DynamicFieldsBuilder.DYNAMIC_TRUE;
            }
        }
        ,
        FALSE,
        STRICT,
        RUNTIME{

            @Override
            DynamicFieldsBuilder getDynamicFieldsBuilder() {
                return DynamicFieldsBuilder.DYNAMIC_RUNTIME;
            }
        };


        DynamicFieldsBuilder getDynamicFieldsBuilder() {
            throw new UnsupportedOperationException("Cannot create dynamic fields when dynamic is set to [" + this + "]");
        }

        static Dynamic getRootDynamic(MappingLookup mappingLookup) {
            Dynamic rootDynamic = mappingLookup.getMapping().getRoot().dynamic;
            return rootDynamic == null ? TRUE : rootDynamic;
        }
    }

    public static class Builder
    extends Mapper.Builder {
        protected final Explicit<Boolean> subobjects;
        protected Explicit<Boolean> enabled = Explicit.IMPLICIT_TRUE;
        protected Dynamic dynamic;
        protected final List<Mapper.Builder> mappersBuilders = new ArrayList<Mapper.Builder>();

        public Builder(String name, Explicit<Boolean> subobjects) {
            super(name);
            this.subobjects = subobjects;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Explicit.explicitBoolean(enabled);
            return this;
        }

        public Builder dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return this;
        }

        private void add(String name, final Mapper mapper) {
            this.add(new Mapper.Builder(name){

                @Override
                public Mapper build(MapperBuilderContext context) {
                    return mapper;
                }
            });
        }

        public final void addDynamic(String name, String prefix, Mapper mapper, DocumentParserContext context) {
            if (!name.contains(".") || !this.subobjects.value().booleanValue()) {
                this.add(name, mapper);
            } else {
                int firstDotIndex = name.indexOf(".");
                String immediateChild = name.substring(0, firstDotIndex);
                String immediateChildFullName = prefix == null ? immediateChild : prefix + "." + immediateChild;
                Builder parentBuilder = Builder.findObjectBuilder(immediateChildFullName, context);
                parentBuilder.addDynamic(name.substring(firstDotIndex + 1), immediateChildFullName, mapper, context);
                this.add(parentBuilder);
            }
        }

        private static Builder findObjectBuilder(String fullName, DocumentParserContext context) {
            ObjectMapper objectMapper = context.mappingLookup().objectMappers().get(fullName);
            if (objectMapper != null) {
                return objectMapper.newBuilder(context.indexSettings().getIndexVersionCreated());
            }
            objectMapper = context.getDynamicObjectMapper(fullName);
            if (objectMapper != null) {
                return objectMapper.newBuilder(context.indexSettings().getIndexVersionCreated());
            }
            throw new IllegalStateException("Missing intermediate object " + fullName);
        }

        protected final Map<String, Mapper> buildMappers(MapperBuilderContext mapperBuilderContext) {
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Mapper mapper = builder.build(mapperBuilderContext);
                assert (!(mapper instanceof ObjectMapper) || this.subobjects.value().booleanValue()) : "unexpected object while subobjects are disabled";
                Mapper existing = (Mapper)mappers.get(mapper.simpleName());
                if (existing != null) {
                    mapper = existing.merge(mapper, mapperBuilderContext);
                }
                mappers.put(mapper.simpleName(), mapper);
            }
            return mappers;
        }

        @Override
        public ObjectMapper build(MapperBuilderContext context) {
            return new ObjectMapper(this.name, context.buildFullName(this.name), this.enabled, this.subobjects, this.dynamic, this.buildMappers(context.createChildContext(this.name)));
        }
    }

    protected record MergeResult(Explicit<Boolean> enabled, Explicit<Boolean> subObjects, Dynamic dynamic, Map<String, Mapper> mappers) {
        public static MergeResult build(ObjectMapper existing, Mapper mergeWith, MapperService.MergeReason reason, MapperBuilderContext parentBuilderContext) {
            Explicit<Boolean> subObjects;
            Explicit<Boolean> enabled;
            if (!(mergeWith instanceof ObjectMapper)) {
                MapperErrors.throwObjectMappingConflictError(mergeWith.name());
            }
            if (!(existing instanceof NestedObjectMapper) && mergeWith instanceof NestedObjectMapper) {
                MapperErrors.throwNestedMappingConflictError(mergeWith.name());
            }
            ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
            if (mergeWithObject.enabled.explicit()) {
                if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                    enabled = mergeWithObject.enabled;
                } else {
                    if (existing.isEnabled() != mergeWithObject.isEnabled()) {
                        throw new MapperException("the [enabled] parameter can't be updated for the object mapping [" + existing.name() + "]");
                    }
                    enabled = existing.enabled;
                }
            } else {
                enabled = existing.enabled;
            }
            if (mergeWithObject.subobjects.explicit()) {
                if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                    subObjects = mergeWithObject.subobjects;
                } else {
                    if (existing.subobjects != mergeWithObject.subobjects) {
                        throw new MapperException("the [subobjects] parameter can't be updated for the object mapping [" + existing.name() + "]");
                    }
                    subObjects = existing.subobjects;
                }
            } else {
                subObjects = existing.subobjects;
            }
            MapperBuilderContext objectBuilderContext = existing.createChildContext(parentBuilderContext, existing.simpleName());
            Map<String, Mapper> mergedMappers = MergeResult.buildMergedMappers(existing, mergeWith, reason, objectBuilderContext);
            return new MergeResult(enabled, subObjects, mergeWithObject.dynamic != null ? mergeWithObject.dynamic : existing.dynamic, mergedMappers);
        }

        private static Map<String, Mapper> buildMergedMappers(ObjectMapper existing, Mapper mergeWith, MapperService.MergeReason reason, MapperBuilderContext objectBuilderContext) {
            Map<Object, Object> mergedMappers = null;
            Iterator iterator = mergeWith.iterator();
            while (iterator.hasNext()) {
                Mapper merged;
                Mapper mergeWithMapper;
                Mapper mergeIntoMapper = (Mapper)(mergedMappers == null ? existing.mappers : mergedMappers).get((mergeWithMapper = (Mapper)iterator.next()).simpleName());
                if (mergeIntoMapper == null) {
                    merged = mergeWithMapper;
                } else if (mergeIntoMapper instanceof ObjectMapper) {
                    ObjectMapper objectMapper = (ObjectMapper)mergeIntoMapper;
                    merged = objectMapper.merge(mergeWithMapper, reason, objectBuilderContext);
                } else {
                    assert (mergeIntoMapper instanceof FieldMapper || mergeIntoMapper instanceof FieldAliasMapper);
                    if (mergeWithMapper instanceof NestedObjectMapper) {
                        MapperErrors.throwNestedMappingConflictError(mergeWithMapper.name());
                    } else if (mergeWithMapper instanceof ObjectMapper) {
                        MapperErrors.throwObjectMappingConflictError(mergeWithMapper.name());
                    }
                    merged = reason == MapperService.MergeReason.INDEX_TEMPLATE ? mergeWithMapper : mergeIntoMapper.merge(mergeWithMapper, objectBuilderContext);
                }
                if (mergedMappers == null) {
                    mergedMappers = new HashMap<String, Mapper>(existing.mappers);
                }
                mergedMappers.put(merged.simpleName(), merged);
            }
            mergedMappers = mergedMappers != null ? Map.copyOf(mergedMappers) : Map.copyOf(existing.mappers);
            return mergedMappers;
        }
    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Explicit<Boolean> SUBOBJECTS = Explicit.IMPLICIT_TRUE;
    }

    private class SyntheticSourceFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private final List<SourceLoader.SyntheticFieldLoader> fields;
        private boolean hasValue;

        private SyntheticSourceFieldLoader(List<SourceLoader.SyntheticFieldLoader> fields) {
            this.fields = fields;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return this.fields.stream().flatMap(SourceLoader.SyntheticFieldLoader::storedFieldLoaders).map(e -> Map.entry((String)e.getKey(), values -> {
                this.hasValue = true;
                ((SourceLoader.SyntheticFieldLoader.StoredFieldLoader)e.getValue()).load(values);
            }));
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders = new ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader>();
            for (SourceLoader.SyntheticFieldLoader field : this.fields) {
                SourceLoader.SyntheticFieldLoader.DocValuesLoader loader = field.docValuesLoader(leafReader, docIdsInLeaf);
                if (loader == null) continue;
                loaders.add(loader);
            }
            if (loaders.isEmpty()) {
                return null;
            }
            return new ObjectDocValuesLoader(loaders);
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            ObjectMapper.this.startSyntheticField(b);
            for (SourceLoader.SyntheticFieldLoader field : this.fields) {
                if (!field.hasValue()) continue;
                field.write(b);
            }
            b.endObject();
            this.hasValue = false;
        }

        private class ObjectDocValuesLoader
        implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
            private final List<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders;

            private ObjectDocValuesLoader(List<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders) {
                this.loaders = loaders;
            }

            @Override
            public boolean advanceToDoc(int docId) throws IOException {
                boolean anyLeafHasDocValues = false;
                for (SourceLoader.SyntheticFieldLoader.DocValuesLoader docValueLoader : this.loaders) {
                    boolean leafHasValue = docValueLoader.advanceToDoc(docId);
                    anyLeafHasDocValues |= leafHasValue;
                }
                SyntheticSourceFieldLoader.this.hasValue |= anyLeafHasDocValues;
                return anyLeafHasDocValues;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public boolean supportsVersion(IndexVersion indexCreatedVersion) {
            return true;
        }

        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            parserContext.incrementMappingObjectDepth();
            Explicit<Boolean> subobjects = TypeParser.parseSubobjects(node);
            Builder builder = new Builder(name, subobjects);
            TypeParser.parseObjectFields(node, parserContext, builder);
            parserContext.decrementMappingObjectDepth();
            return builder;
        }

        static void parseObjectFields(Map<String, Object> node, MappingParserContext parserContext, Builder builder) {
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder)) continue;
                iterator.remove();
            }
        }

        protected static boolean parseObjectOrDocumentTypeProperties(String fieldName, Object fieldNode, MappingParserContext parserContext, Builder builder) {
            if (fieldName.equals("dynamic")) {
                String value = fieldNode.toString();
                if (value.equalsIgnoreCase("strict")) {
                    builder.dynamic(Dynamic.STRICT);
                } else if (value.equalsIgnoreCase("runtime")) {
                    builder.dynamic(Dynamic.RUNTIME);
                } else {
                    boolean dynamic = XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".dynamic");
                    builder.dynamic(dynamic ? Dynamic.TRUE : Dynamic.FALSE);
                }
                return true;
            }
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".enabled"));
                return true;
            }
            if (fieldName.equals("properties")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (!(fieldNode instanceof Map)) {
                        throw new ElasticsearchParseException("properties must be a map type", new Object[0]);
                    }
                    TypeParser.parseProperties(builder, (Map)fieldNode, parserContext);
                }
                return true;
            }
            if (fieldName.equals("include_in_all")) {
                deprecationLogger.warn(DeprecationCategory.MAPPINGS, "include_in_all", "[include_in_all] is deprecated, the _all field have been removed in this version", new Object[0]);
                return true;
            }
            return false;
        }

        protected static Explicit<Boolean> parseSubobjects(Map<String, Object> node) {
            Object subobjectsNode = node.remove("subobjects");
            if (subobjectsNode != null) {
                return Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(subobjectsNode, "subobjects.subobjects"));
            }
            return Defaults.SUBOBJECTS;
        }

        protected static void parseProperties(Builder objBuilder, Map<String, Object> propsNode, MappingParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = propsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                ObjectMapper.validateFieldName(fieldName, parserContext.indexVersionCreated());
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    Mapper.Builder fieldBuilder;
                    String type;
                    Map propNode = (Map)entry.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                    } else if (propNode.get("properties") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else {
                        throw new MapperParsingException("No type specified for field [" + fieldName + "]");
                    }
                    if (!objBuilder.subobjects.value().booleanValue() && type.equals(ObjectMapper.CONTENT_TYPE)) {
                        throw new MapperParsingException("Tried to add subobject [" + fieldName + "] to object [" + objBuilder.name() + "] which does not support subobjects");
                    }
                    if (!objBuilder.subobjects.value().booleanValue() && type.equals("nested")) {
                        throw new MapperParsingException("Tried to add nested object [" + fieldName + "] to object [" + objBuilder.name() + "] which does not support subobjects");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    if (!objBuilder.subobjects.value().booleanValue()) {
                        fieldBuilder = typeParser.parse(fieldName, propNode, parserContext);
                    } else {
                        String[] fieldNameParts = fieldName.split("\\.");
                        if (fieldNameParts.length == 0) {
                            throw new IllegalArgumentException("field name cannot contain only dots");
                        }
                        String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                        ObjectMapper.validateFieldName(realFieldName, parserContext.indexVersionCreated());
                        fieldBuilder = typeParser.parse(realFieldName, propNode, parserContext);
                        for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                            String intermediateObjectName = fieldNameParts[i];
                            ObjectMapper.validateFieldName(intermediateObjectName, parserContext.indexVersionCreated());
                            Builder intermediate = new Builder(intermediateObjectName, Defaults.SUBOBJECTS);
                            intermediate.add(fieldBuilder);
                            fieldBuilder = intermediate;
                        }
                    }
                    objBuilder.add(fieldBuilder);
                    propNode.remove("type");
                    MappingParser.checkNoRemainingFields(fieldName, propNode);
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [fields] on field [" + fieldName + "] but got a " + fieldName.getClass());
            }
            MappingParser.checkNoRemainingFields(propsNode, "DocType mapping definition has unsupported parameters: ");
        }
    }
}

