/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public abstract class IgnoreMalformedStoredValues {
    private static final Empty EMPTY = new Empty();

    public static StoredField storedField(String fieldName, XContentParser parser) throws IOException {
        StoredField storedField;
        String name = IgnoreMalformedStoredValues.name(fieldName);
        switch (parser.currentToken()) {
            case VALUE_STRING: {
                StoredField storedField2;
                storedField = storedField2 = new StoredField(name, parser.text());
                break;
            }
            case VALUE_NUMBER: {
                StoredField storedField3;
                storedField = storedField3 = (switch (parser.numberType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case XContentParser.NumberType.INT -> new StoredField(name, parser.intValue());
                    case XContentParser.NumberType.LONG -> new StoredField(name, parser.longValue());
                    case XContentParser.NumberType.DOUBLE -> new StoredField(name, parser.doubleValue());
                    case XContentParser.NumberType.FLOAT -> new StoredField(name, parser.floatValue());
                    case XContentParser.NumberType.BIG_INTEGER -> new StoredField(name, IgnoreMalformedStoredValues.encode((BigInteger)parser.numberValue()));
                    case XContentParser.NumberType.BIG_DECIMAL -> new StoredField(name, IgnoreMalformedStoredValues.encode((BigDecimal)parser.numberValue()));
                });
                break;
            }
            case VALUE_BOOLEAN: {
                StoredField storedField4;
                storedField = storedField4 = new StoredField(name, new byte[]{parser.booleanValue() ? (byte)116 : 102});
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                StoredField storedField5;
                storedField = storedField5 = new StoredField(name, IgnoreMalformedStoredValues.encode(parser.binaryValue()));
                break;
            }
            case START_OBJECT: 
            case START_ARRAY: {
                try (XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());){
                    builder.copyCurrentStructure(parser);
                    StoredField storedField6 = new StoredField(name, IgnoreMalformedStoredValues.encode(builder));
                    storedField = storedField6;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("synthetic _source doesn't support malformed objects");
            }
        }
        return storedField;
    }

    public static IgnoreMalformedStoredValues empty() {
        return EMPTY;
    }

    public static IgnoreMalformedStoredValues stored(String fieldName) {
        return new Stored(fieldName);
    }

    public abstract Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders();

    public abstract int count();

    public abstract void write(XContentBuilder var1) throws IOException;

    private static String name(String fieldName) {
        return fieldName + "._ignore_malformed";
    }

    private static byte[] encode(BigInteger n) {
        byte[] twosCompliment = n.toByteArray();
        byte[] encoded = new byte[1 + twosCompliment.length];
        encoded[0] = 105;
        System.arraycopy(twosCompliment, 0, encoded, 1, twosCompliment.length);
        return encoded;
    }

    private static byte[] encode(BigDecimal n) {
        byte[] twosCompliment = n.unscaledValue().toByteArray();
        byte[] encoded = new byte[5 + twosCompliment.length];
        encoded[0] = 100;
        ByteUtils.writeIntLE(n.scale(), encoded, 1);
        System.arraycopy(twosCompliment, 0, encoded, 5, twosCompliment.length);
        return encoded;
    }

    private static byte[] encode(byte[] b) {
        byte[] encoded = new byte[1 + b.length];
        encoded[0] = 98;
        System.arraycopy(b, 0, encoded, 1, b.length);
        return encoded;
    }

    private static byte[] encode(XContentBuilder builder) throws IOException {
        BytesRef ref;
        BytesReference b = BytesReference.bytes(builder);
        byte[] encoded = new byte[1 + b.length()];
        encoded[0] = switch (builder.contentType()) {
            case XContentType.JSON -> 106;
            case XContentType.SMILE -> 115;
            case XContentType.YAML -> 121;
            case XContentType.CBOR -> 99;
            default -> throw new IllegalArgumentException("unsupported type " + builder.contentType());
        };
        int position = 1;
        BytesRefIterator itr = b.iterator();
        while ((ref = itr.next()) != null) {
            System.arraycopy(ref.bytes, ref.offset, encoded, position, ref.length);
            position += ref.length;
        }
        assert (position == encoded.length);
        return encoded;
    }

    private static class Empty
    extends IgnoreMalformedStoredValues {
        private Empty() {
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.empty();
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
        }
    }

    private static class Stored
    extends IgnoreMalformedStoredValues {
        private final String fieldName;
        private List<Object> values = Collections.emptyList();

        Stored(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(Map.entry(IgnoreMalformedStoredValues.name(this.fieldName), values -> {
                this.values = values;
            }));
        }

        @Override
        public int count() {
            return this.values.size();
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            for (Object v : this.values) {
                if (v instanceof BytesRef) {
                    BytesRef r = (BytesRef)v;
                    Stored.decodeAndWrite(b, r);
                    continue;
                }
                b.value(v);
            }
            this.values = Collections.emptyList();
        }

        private static void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
            switch (r.bytes[r.offset]) {
                case 98: {
                    b.value(r.bytes, r.offset + 1, r.length - 1);
                    return;
                }
                case 99: {
                    Stored.decodeAndWriteXContent(b, XContentType.CBOR, r);
                    return;
                }
                case 100: {
                    if (r.length < 5) {
                        throw new IllegalArgumentException("Can't decode " + r);
                    }
                    int scale = ByteUtils.readIntLE(r.bytes, r.offset + 1);
                    b.value(new BigDecimal(new BigInteger(r.bytes, r.offset + 5, r.length - 5), scale));
                    return;
                }
                case 102: {
                    if (r.length != 1) {
                        throw new IllegalArgumentException("Can't decode " + r);
                    }
                    b.value(false);
                    return;
                }
                case 105: {
                    b.value(new BigInteger(r.bytes, r.offset + 1, r.length - 1));
                    return;
                }
                case 106: {
                    Stored.decodeAndWriteXContent(b, XContentType.JSON, r);
                    return;
                }
                case 115: {
                    Stored.decodeAndWriteXContent(b, XContentType.SMILE, r);
                    return;
                }
                case 116: {
                    if (r.length != 1) {
                        throw new IllegalArgumentException("Can't decode " + r);
                    }
                    b.value(true);
                    return;
                }
                case 121: {
                    Stored.decodeAndWriteXContent(b, XContentType.YAML, r);
                    return;
                }
            }
            throw new IllegalArgumentException("Can't decode " + r);
        }

        private static void decodeAndWriteXContent(XContentBuilder b, XContentType type, BytesRef r) throws IOException {
            BytesArray ref = new BytesArray(r.bytes, r.offset + 1, r.length - 1);
            try (XContentParser parser = type.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)ref.streamInput());){
                b.copyCurrentStructure(parser);
            }
        }
    }
}

