/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.GeoShapeParser;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;

public class GeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(GeoShapeFieldMapper.class);
    public static final String CONTENT_TYPE = "geo_shape";
    @Deprecated
    public static Mapper.TypeParser PARSER = (name, node, parserContext) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
        boolean coerceByDefault = (Boolean)COERCE_SETTING.get(parserContext.getSettings());
        Builder builder = new Builder(name, ignoreMalformedByDefault, coerceByDefault);
        builder.parse(name, parserContext, node);
        return builder;
    };
    private final Builder builder;
    private final GeoShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((GeoShapeFieldMapper)in).builder;
    }

    public GeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, GeoShapeIndexer indexer, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, builder.ignoreMalformed.get(), builder.coerce.get(), builder.ignoreZValue.get(), builder.orientation.get(), multiFields, copyTo, parser);
        this.builder = builder;
        this.indexer = indexer;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.ignoreMalformed.getDefaultValue().value(), this.builder.coerce.getDefaultValue().value()).init(this);
    }

    @Override
    protected void index(DocumentParserContext context, Geometry geometry) {
        if (geometry == null) {
            return;
        }
        context.doc().addAll(this.indexer.indexShape(geometry));
        context.addToFieldNames(this.fieldType().name());
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue.setValue(Explicit.explicitBoolean(ignoreZValue));
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta};
        }

        @Override
        public GeoShapeFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "geo_shape_multifields", "Adding multifields to [geo_shape] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            GeometryParser geometryParser = new GeometryParser(this.orientation.get().value().getAsBoolean(), this.coerce.get().value(), this.ignoreZValue.get().value());
            GeoShapeParser geoShapeParser = new GeoShapeParser(geometryParser, this.orientation.get().value());
            GeoShapeFieldType ft = new GeoShapeFieldType(context.buildFullName(this.name), this.indexed.get(), this.orientation.get().value(), geoShapeParser, this.meta.get());
            return new GeoShapeFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, context), this.copyTo, new GeoShapeIndexer(this.orientation.get().value(), context.buildFullName(this.name)), geoShapeParser, this);
        }
    }

    public static class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry>
    implements GeoShapeQueryable {
        public GeoShapeFieldType(String name, boolean indexed, Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, Map<String, String> meta) {
            super(name, indexed, false, false, parser, orientation, meta);
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(IndexVersions.V_7_5_0)) {
                throw new QueryShardException((QueryRewriteContext)context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            return LatLonShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])geometries);
        }

        @Override
        protected Function<List<Geometry>, List<Object>> getFormatter(String format) {
            return GeometryFormatterFactory.getFormatter(format, Function.identity());
        }
    }
}

