/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;

public abstract class AbstractGeometryFieldMapper<T>
extends FieldMapper {
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> ignoreZValue;
    private final Parser<T> parser;

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformedParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean ignoreMalformedByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, initializer, ignoreMalformedByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreZValueParam(Function<FieldMapper, Explicit<Boolean>> initializer) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_z_value", true, initializer, true);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser) {
        super(simpleName, mappedFieldType, multiFields, copyTo, false, null);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.parser = parser;
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser, OnScriptError onScriptError) {
        super(simpleName, mappedFieldType, multiFields, copyTo, true, onScriptError);
        this.ignoreMalformed = Explicit.EXPLICIT_FALSE;
        this.ignoreZValue = Explicit.EXPLICIT_FALSE;
        this.parser = parser;
    }

    @Override
    public AbstractGeometryFieldType<T> fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void index(DocumentParserContext var1, T var2) throws IOException;

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    @Override
    public final void parse(DocumentParserContext context) throws IOException {
        if (this.hasScript) {
            throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type + " + this.contentType() + "]", new IllegalArgumentException("Cannot index data directly into a field with a [script] parameter"));
        }
        this.parser.parse(context.parser(), v -> this.index(context, v), e -> {
            if (!this.ignoreMalformed()) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.contentType() + "]", (Exception)e);
            }
            context.addIgnoredField(this.fieldType().name());
        });
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    public boolean ignoreZValue() {
        return this.ignoreZValue.value();
    }

    @Override
    public final boolean parsesArrayValue() {
        return true;
    }

    public static abstract class Parser<T> {
        public abstract void parse(XContentParser var1, CheckedConsumer<T, IOException> var2, Consumer<Exception> var3) throws IOException;

        private void fetchFromSource(Object sourceMap, Consumer<T> consumer) {
            try (XContentParser parser = Parser.wrapObject(sourceMap);){
                this.parse(parser, v -> consumer.accept(this.normalizeFromSource(v)), e -> {});
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        public abstract T normalizeFromSource(T var1);

        private static XContentParser wrapObject(Object sourceMap) throws IOException {
            MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, Collections.singletonMap("dummy_field", sourceMap), XContentType.JSON);
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            return parser;
        }
    }

    public static abstract class AbstractGeometryFieldType<T>
    extends MappedFieldType {
        protected final Parser<T> geometryParser;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Parser<T> geometryParser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.NONE, meta);
            this.geometryParser = geometryParser;
        }

        @Override
        public final Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
        }

        protected abstract Function<List<T>, List<Object>> getFormatter(String var1);

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            final Function<List<T>, List<Object>> formatter = this.getFormatter(format != null ? format : "geojson");
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    ArrayList values = new ArrayList();
                    geometryParser.fetchFromSource(value, values::add);
                    return formatter.apply(values);
                }
            };
        }

        public ValueFetcher valueFetcher(Set<String> sourcePaths, Object nullValue, String format) {
            final Function<List<T>, List<Object>> formatter = this.getFormatter(format != null ? format : "geojson");
            return new ArraySourceValueFetcher(sourcePaths, nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    ArrayList values = new ArrayList();
                    geometryParser.fetchFromSource(value, values::add);
                    return formatter.apply(values);
                }
            };
        }
    }
}

