/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record IndexVersion(int id, Version luceneVersion) implements VersionId<IndexVersion>,
ToXContentFragment
{
    public static IndexVersion readVersion(StreamInput in) throws IOException {
        return IndexVersion.fromId(in.readVInt());
    }

    public static IndexVersion fromId(int id) {
        IndexVersion known = (IndexVersion)IndexVersions.VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        Map.Entry<Integer, IndexVersion> prev = IndexVersions.VERSION_IDS.floorEntry(id);
        Version luceneVersion = prev != null ? prev.getValue().luceneVersion : Version.fromBits((int)(IndexVersions.VERSION_IDS.firstEntry().getValue().luceneVersion.major - 1), (int)0, (int)0);
        return new IndexVersion(id, luceneVersion);
    }

    public static void writeVersion(IndexVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static IndexVersion min(IndexVersion version1, IndexVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static IndexVersion max(IndexVersion version1, IndexVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static IndexVersion current() {
        return CurrentHolder.CURRENT;
    }

    public boolean isLegacyIndexVersion() {
        return this.before(IndexVersions.MINIMUM_COMPATIBLE);
    }

    public static IndexVersion getMinimumCompatibleIndexVersion(int versionId) {
        int major = versionId / 1000000;
        if (major == IndexVersion.current().id() / 1000000) {
            return IndexVersions.MINIMUM_COMPATIBLE;
        }
        int compatId = (major - 1) * 1000000;
        if (major <= 8) {
            compatId += 99;
        }
        return IndexVersion.fromId(compatId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexVersion version = (IndexVersion)o;
        return this.id == version.id;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    private static class CurrentHolder {
        private static final IndexVersion CURRENT = CurrentHolder.findCurrent();

        private CurrentHolder() {
        }

        private static IndexVersion findCurrent() {
            VersionExtension versionExtension = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class), () -> null);
            if (versionExtension == null) {
                return IndexVersions.LATEST_DEFINED;
            }
            IndexVersion version = versionExtension.getCurrentIndexVersion(IndexVersions.LATEST_DEFINED);
            assert (version.onOrAfter(IndexVersions.LATEST_DEFINED));
            assert (version.luceneVersion.equals((Object)Version.LATEST)) : "IndexVersion must be upgraded to [" + Version.LATEST + "] is still set to [" + version.luceneVersion + "]";
            return version;
        }
    }
}

