/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.FrequencyCappedAction;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeAllocationOrdering;
import org.elasticsearch.cluster.routing.allocation.allocator.OrderedShardsIterator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongGaugeMetric;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.ThreadPool;

public class DesiredBalanceReconciler {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceReconciler.class);
    public static final Setting<TimeValue> UNDESIRED_ALLOCATIONS_LOG_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.undesired_allocations.log_interval", TimeValue.timeValueHours((long)1L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> UNDESIRED_ALLOCATIONS_LOG_THRESHOLD_SETTING = Setting.doubleSetting("cluster.routing.allocation.desired_balance.undesired_allocations.threshold", 0.1, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final FrequencyCappedAction undesiredAllocationLogInterval;
    private double undesiredAllocationsLogThreshold;
    private final NodeAllocationOrdering allocationOrdering = new NodeAllocationOrdering();
    private final NodeAllocationOrdering moveOrdering = new NodeAllocationOrdering();
    protected final LongGaugeMetric unassignedShards;
    protected final LongGaugeMetric totalAllocations;
    protected final LongGaugeMetric undesiredAllocations;
    private final DoubleGauge undesiredAllocationsRatio;

    public DesiredBalanceReconciler(ClusterSettings clusterSettings, ThreadPool threadPool, MeterRegistry meterRegistry) {
        this.undesiredAllocationLogInterval = new FrequencyCappedAction(threadPool);
        clusterSettings.initializeAndWatch(UNDESIRED_ALLOCATIONS_LOG_INTERVAL_SETTING, this.undesiredAllocationLogInterval::setMinInterval);
        clusterSettings.initializeAndWatch(UNDESIRED_ALLOCATIONS_LOG_THRESHOLD_SETTING, value -> {
            this.undesiredAllocationsLogThreshold = value;
        });
        this.unassignedShards = LongGaugeMetric.create(meterRegistry, "es.allocator.desired_balance.shards.unassigned", "Unassigned shards count", "{shard}");
        this.totalAllocations = LongGaugeMetric.create(meterRegistry, "es.allocator.desired_balance.shards.count", "Total shards count", "{shard}");
        this.undesiredAllocations = LongGaugeMetric.create(meterRegistry, "es.allocator.desired_balance.allocations.undesired", "Count of shards allocated on undesired nodes", "{shard}");
        this.undesiredAllocationsRatio = meterRegistry.registerDoubleGauge("es.allocator.desired_balance.allocations.undesired_ratio", "Ratio of undesired allocations to shard count", "1", () -> {
            long total = this.totalAllocations.get();
            long undesired = this.undesiredAllocations.get();
            return new DoubleWithAttributes(total != 0L ? (double)undesired / (double)total : 0.0);
        });
    }

    public void reconcile(DesiredBalance desiredBalance, RoutingAllocation allocation) {
        Set<String> nodeIds = allocation.routingNodes().getAllNodeIds();
        this.allocationOrdering.retainNodes(nodeIds);
        this.moveOrdering.retainNodes(nodeIds);
        new Reconciliation(desiredBalance, allocation).run();
    }

    public void clear() {
        this.allocationOrdering.clear();
        this.moveOrdering.clear();
    }

    private class Reconciliation {
        private final DesiredBalance desiredBalance;
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;

        Reconciliation(DesiredBalance desiredBalance, RoutingAllocation allocation) {
            this.desiredBalance = desiredBalance;
            this.allocation = allocation;
            this.routingNodes = allocation.routingNodes();
        }

        void run() {
            try (Releasable ignored = this.allocation.withReconcilingFlag();){
                logger.debug("Reconciling desired balance for [{}]", (Object)this.desiredBalance.lastConvergedIndex());
                if (this.routingNodes.size() == 0) {
                    this.failAllocationOfNewPrimaries(this.allocation);
                    logger.trace("no nodes available, nothing to reconcile");
                    return;
                }
                if (this.desiredBalance.assignments().isEmpty()) {
                    logger.trace("desired balance is empty, nothing to reconcile");
                    return;
                }
                logger.trace("Reconciler#allocateUnassigned");
                this.allocateUnassigned();
                assert (this.allocateUnassignedInvariant());
                logger.trace("Reconciler#moveShards");
                this.moveShards();
                logger.trace("Reconciler#balance");
                this.balance();
                logger.debug("Reconciliation is complete");
            }
        }

        private boolean allocateUnassignedInvariant() {
            assert (this.routingNodes.unassigned().isEmpty());
            Map<ShardId, Integer> shardCounts = this.allocation.metadata().stream().filter(indexMetadata -> indexMetadata.getCreationVersion().onOrAfter(IndexVersions.V_7_2_0) || indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)).flatMap(indexMetadata -> IntStream.range(0, indexMetadata.getNumberOfShards()).mapToObj(shardId -> Tuple.tuple((Object)new ShardId(indexMetadata.getIndex(), shardId), (Object)(indexMetadata.getNumberOfReplicas() + 1)))).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            for (ShardRouting shardRouting : this.routingNodes.unassigned().ignored()) {
                shardCounts.computeIfPresent(shardRouting.shardId(), (ignored, count) -> count == 1 ? null : Integer.valueOf(count - 1));
            }
            for (RoutingNode routingNode : this.routingNodes) {
                for (ShardRouting shardRouting : routingNode) {
                    shardCounts.computeIfPresent(shardRouting.shardId(), (ignored, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                }
            }
            assert (shardCounts.isEmpty()) : shardCounts;
            return true;
        }

        private void failAllocationOfNewPrimaries(RoutingAllocation allocation) {
            RoutingNodes routingNodes = allocation.routingNodes();
            assert (routingNodes.size() == 0) : routingNodes;
            RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
            while (unassignedIterator.hasNext()) {
                ShardRouting shardRouting = unassignedIterator.next();
                UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
                if (!shardRouting.primary() || unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
                unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), unassignedInfo.isDelayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, unassignedInfo.getFailedNodeIds(), unassignedInfo.getLastAllocatedNodeId()), shardRouting.recoverySource(), allocation.changes());
            }
        }

        private void allocateUnassigned() {
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            if (logger.isTraceEnabled()) {
                logger.trace("Start allocating unassigned shards: {}", (Object)this.routingNodes.toString());
            }
            if (unassigned.isEmpty()) {
                return;
            }
            PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator comparator = (o1, o2) -> {
                if (o1.primary() ^ o2.primary()) {
                    return o1.primary() ? -1 : 1;
                }
                if (o1.getIndexName().compareTo(o2.getIndexName()) == 0) {
                    return o1.getId() - o2.getId();
                }
                int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
                assert (secondary != 0) : "Index names are equal, should be returned early.";
                return secondary;
            };
            Object[] primary = unassigned.drain();
            Object[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
            do {
                block6: for (int i = 0; i < primaryLength; ++i) {
                    UnassignedInfo.AllocationStatus unallocatedStatus;
                    boolean ignored;
                    Object shard = primary[i];
                    ShardAssignment assignment = this.desiredBalance.getAssignment(((ShardRouting)shard).shardId());
                    boolean bl = ignored = assignment == null || this.isIgnored(this.routingNodes, (ShardRouting)shard, assignment);
                    if (ignored) {
                        unallocatedStatus = UnassignedInfo.AllocationStatus.NO_ATTEMPT;
                    } else {
                        unallocatedStatus = UnassignedInfo.AllocationStatus.DECIDERS_NO;
                        NodeIdsIterator nodeIdsIterator = new NodeIdsIterator((ShardRouting)shard, assignment);
                        while (nodeIdsIterator.hasNext()) {
                            String nodeId = nodeIdsIterator.next();
                            RoutingNode routingNode = this.routingNodes.node(nodeId);
                            if (routingNode == null || routingNode.getByShardId(((ShardRouting)shard).shardId()) != null) continue;
                            Decision decision = this.allocation.deciders().canAllocate((ShardRouting)shard, routingNode, this.allocation);
                            switch (decision.type()) {
                                case YES: {
                                    logger.debug("Assigning shard [{}] to {} [{}]", shard, (Object)nodeIdsIterator.source, (Object)nodeId);
                                    long shardSize = ExpectedShardSizeEstimator.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation);
                                    this.routingNodes.initializeShard((ShardRouting)shard, nodeId, null, shardSize, this.allocation.changes());
                                    DesiredBalanceReconciler.this.allocationOrdering.recordAllocation(nodeId);
                                    if (((ShardRouting)shard).primary()) continue block6;
                                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                                        secondary[secondaryLength++] = primary[++i];
                                    }
                                    continue block6;
                                }
                                case THROTTLE: {
                                    nodeIdsIterator.wasThrottled = true;
                                    unallocatedStatus = UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED;
                                    logger.debug("Couldn't assign shard [{}] to [{}]: {}", (Object)((ShardRouting)shard).shardId(), (Object)nodeId, (Object)decision);
                                    break;
                                }
                                case NO: {
                                    logger.debug("Couldn't assign shard [{}] to [{}]: {}", (Object)((ShardRouting)shard).shardId(), (Object)nodeId, (Object)decision);
                                }
                            }
                        }
                    }
                    logger.debug("No eligible node found to assign shard [{}]", shard);
                    unassigned.ignoreShard((ShardRouting)shard, unallocatedStatus, this.allocation.changes());
                    if (((ShardRouting)shard).primary()) continue;
                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                        unassigned.ignoreShard((ShardRouting)primary[++i], unallocatedStatus, this.allocation.changes());
                    }
                }
                primaryLength = secondaryLength;
                Object[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
        }

        private boolean isIgnored(RoutingNodes routingNodes, ShardRouting shard, ShardAssignment assignment) {
            if (assignment.ignored() == 0) {
                return false;
            }
            if (assignment.ignored() == assignment.total()) {
                return true;
            }
            if (assignment.total() - assignment.ignored() == 1) {
                return !shard.primary();
            }
            int assigned = 0;
            for (RoutingNode routingNode : routingNodes) {
                ShardRouting assignedShard = routingNode.getByShardId(shard.shardId());
                if (assignedShard == null || assignedShard.relocating()) continue;
                ++assigned;
            }
            return assignment.total() - assignment.ignored() <= assigned;
        }

        private void moveShards() {
            OrderedShardsIterator iterator = OrderedShardsIterator.create(this.routingNodes, DesiredBalanceReconciler.this.moveOrdering);
            while (iterator.hasNext()) {
                DiscoveryNode moveTarget;
                ShardAssignment assignment;
                ShardRouting shardRouting = iterator.next();
                if (!shardRouting.started() || (assignment = this.desiredBalance.getAssignment(shardRouting.shardId())) == null || assignment.nodeIds().contains(shardRouting.currentNodeId()) || this.allocation.deciders().canAllocate(shardRouting, this.allocation).type() != Decision.Type.YES) continue;
                RoutingNode routingNode = this.routingNodes.node(shardRouting.currentNodeId());
                Decision canRemainDecision = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
                if (canRemainDecision.type() != Decision.Type.NO || (moveTarget = this.findRelocationTarget(shardRouting, assignment.nodeIds())) == null) continue;
                logger.debug("Moving shard {} from {} to {}", (Object)shardRouting.shardId(), (Object)shardRouting.currentNodeId(), (Object)moveTarget.getId());
                this.routingNodes.relocateShard(shardRouting, moveTarget.getId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
                iterator.dePrioritizeNode(shardRouting.currentNodeId());
                DesiredBalanceReconciler.this.moveOrdering.recordAllocation(shardRouting.currentNodeId());
            }
        }

        private void balance() {
            if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
                return;
            }
            int unassignedShards = this.routingNodes.unassigned().size() + this.routingNodes.unassigned().ignored().size();
            int totalAllocations = 0;
            int undesiredAllocations = 0;
            OrderedShardsIterator iterator = OrderedShardsIterator.create(this.routingNodes, DesiredBalanceReconciler.this.moveOrdering);
            while (iterator.hasNext()) {
                DiscoveryNode rebalanceTarget;
                ShardAssignment assignment;
                ShardRouting shardRouting = iterator.next();
                ++totalAllocations;
                if (!shardRouting.started() || (assignment = this.desiredBalance.getAssignment(shardRouting.shardId())) == null || assignment.nodeIds().contains(shardRouting.currentNodeId())) continue;
                ++undesiredAllocations;
                if (this.allocation.deciders().canRebalance(shardRouting, this.allocation).type() != Decision.Type.YES || this.allocation.deciders().canAllocate(shardRouting, this.allocation).type() != Decision.Type.YES || (rebalanceTarget = this.findRelocationTarget(shardRouting, assignment.nodeIds(), this::decideCanAllocate)) == null) continue;
                logger.debug("Rebalancing shard {} from {} to {}", (Object)shardRouting.shardId(), (Object)shardRouting.currentNodeId(), (Object)rebalanceTarget.getId());
                this.routingNodes.relocateShard(shardRouting, rebalanceTarget.getId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
                iterator.dePrioritizeNode(shardRouting.currentNodeId());
                DesiredBalanceReconciler.this.moveOrdering.recordAllocation(shardRouting.currentNodeId());
            }
            DesiredBalanceReconciler.this.unassignedShards.set(unassignedShards);
            DesiredBalanceReconciler.this.undesiredAllocations.set(undesiredAllocations);
            DesiredBalanceReconciler.this.totalAllocations.set(totalAllocations);
            this.maybeLogUndesiredAllocationsWarning(totalAllocations, undesiredAllocations, this.routingNodes.size());
        }

        private void maybeLogUndesiredAllocationsWarning(int allAllocations, int undesiredAllocations, int nodeCount) {
            boolean warningThresholdReached;
            boolean nonEmptyRelocationBacklog = (long)undesiredAllocations > 2L * (long)nodeCount;
            boolean bl = warningThresholdReached = (double)undesiredAllocations > DesiredBalanceReconciler.this.undesiredAllocationsLogThreshold * (double)allAllocations;
            if (allAllocations > 0 && nonEmptyRelocationBacklog && warningThresholdReached) {
                DesiredBalanceReconciler.this.undesiredAllocationLogInterval.maybeExecute(() -> logger.warn("[{}] of assigned shards ({}/{}) are not on their desired nodes, which exceeds the warn threshold of [{}]", (Object)Strings.format1Decimals(100.0 * (double)undesiredAllocations / (double)allAllocations, "%"), (Object)undesiredAllocations, (Object)allAllocations, (Object)Strings.format1Decimals(100.0 * DesiredBalanceReconciler.this.undesiredAllocationsLogThreshold, "%")));
            }
        }

        private DiscoveryNode findRelocationTarget(ShardRouting shardRouting, Set<String> desiredNodeIds) {
            DiscoveryNode moveDecision = this.findRelocationTarget(shardRouting, desiredNodeIds, this::decideCanAllocate);
            if (moveDecision != null) {
                return moveDecision;
            }
            boolean shardsOnReplacedNode = this.allocation.metadata().nodeShutdowns().contains(shardRouting.currentNodeId(), SingleNodeShutdownMetadata.Type.REPLACE);
            if (shardsOnReplacedNode) {
                return this.findRelocationTarget(shardRouting, desiredNodeIds, this::decideCanForceAllocateForVacate);
            }
            return null;
        }

        private DiscoveryNode findRelocationTarget(ShardRouting shardRouting, Set<String> desiredNodeIds, BiFunction<ShardRouting, RoutingNode, Decision> canAllocateDecider) {
            for (String nodeId : desiredNodeIds) {
                RoutingNode node;
                if (nodeId.equals(shardRouting.currentNodeId()) || (node = this.routingNodes.node(nodeId)) == null) continue;
                Decision decision = canAllocateDecider.apply(shardRouting, node);
                logger.trace("relocate {} to {}: {}", (Object)shardRouting, (Object)nodeId, (Object)decision);
                if (decision.type() != Decision.Type.YES) continue;
                return node.node();
            }
            return null;
        }

        private Decision decideCanAllocate(ShardRouting shardRouting, RoutingNode target) {
            assert (target != null) : "Target node is not found";
            return this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
        }

        private Decision decideCanForceAllocateForVacate(ShardRouting shardRouting, RoutingNode target) {
            assert (target != null) : "Target node is not found";
            return this.allocation.deciders().canForceAllocateDuringReplace(shardRouting, target, this.allocation);
        }

        private final class NodeIdsIterator
        implements Iterator<String> {
            private final ShardRouting shard;
            private NodeIdSource source;
            private Iterator<String> nodeIds;
            private boolean wasThrottled = false;

            NodeIdsIterator(ShardRouting shard, ShardAssignment assignment) {
                this.shard = shard;
                Optional<Set<String>> forcedInitialAllocation = Reconciliation.this.allocation.deciders().getForcedInitialShardAllocationToNodes(shard, Reconciliation.this.allocation);
                if (forcedInitialAllocation.isPresent()) {
                    logger.debug("Shard [{}] initial allocation is forced to {}", (Object)shard.shardId(), forcedInitialAllocation.get());
                    this.nodeIds = DesiredBalanceReconciler.this.allocationOrdering.sort((Collection<String>)forcedInitialAllocation.get()).iterator();
                    this.source = NodeIdSource.FORCED_INITIAL_ALLOCATION;
                } else {
                    this.nodeIds = DesiredBalanceReconciler.this.allocationOrdering.sort(assignment.nodeIds()).iterator();
                    this.source = NodeIdSource.DESIRED;
                }
            }

            @Override
            public boolean hasNext() {
                if (!this.nodeIds.hasNext() && this.source == NodeIdSource.DESIRED && this.shard.primary() && !this.wasThrottled) {
                    Set<String> fallbackNodeIds = Reconciliation.this.allocation.routingNodes().getAllNodeIds();
                    logger.debug("Shard [{}] assignment is temporarily not possible. Falling back to {}", (Object)this.shard.shardId(), fallbackNodeIds);
                    this.nodeIds = DesiredBalanceReconciler.this.allocationOrdering.sort(fallbackNodeIds).iterator();
                    this.source = NodeIdSource.FALLBACK;
                }
                return this.nodeIds.hasNext();
            }

            @Override
            public String next() {
                return this.nodeIds.next();
            }
        }

        private static enum NodeIdSource {
            DESIRED,
            FORCED_INITIAL_ALLOCATION,
            FALLBACK;

        }
    }
}

