/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Set;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;

public class ExpectedShardSizeEstimator {
    public static long getExpectedShardSize(ShardRouting shardRouting, long defaultSize, RoutingAllocation allocation) {
        return ExpectedShardSizeEstimator.getExpectedShardSize(shardRouting, defaultSize, allocation.clusterInfo(), allocation.snapshotShardSizeInfo(), allocation.metadata(), allocation.routingTable());
    }

    public static long getExpectedShardSize(ShardRouting shard, long defaultValue, ClusterInfo clusterInfo, SnapshotShardSizeInfo snapshotShardSizeInfo, Metadata metadata, RoutingTable routingTable) {
        IndexMetadata indexMetadata = metadata.getIndexSafe(shard.index());
        if (indexMetadata.getResizeSourceIndex() != null && !shard.active() && shard.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
            return ExpectedShardSizeEstimator.getExpectedSizeOfResizedShard(shard, defaultValue, indexMetadata, clusterInfo, metadata, routingTable);
        }
        if (shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
            return snapshotShardSizeInfo.getShardSize(shard, defaultValue);
        }
        return clusterInfo.getShardSize(shard, defaultValue);
    }

    private static long getExpectedSizeOfResizedShard(ShardRouting shard, long defaultValue, IndexMetadata indexMetadata, ClusterInfo clusterInfo, Metadata metadata, RoutingTable routingTable) {
        long targetShardSize = 0L;
        Index mergeSourceIndex = indexMetadata.getResizeSourceIndex();
        IndexMetadata sourceIndexMetadata = metadata.index(mergeSourceIndex);
        if (sourceIndexMetadata != null) {
            Set<ShardId> shardIds = IndexMetadata.selectRecoverFromShards(shard.id(), sourceIndexMetadata, indexMetadata.getNumberOfShards());
            IndexRoutingTable indexRoutingTable = routingTable.index(mergeSourceIndex.getName());
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                if (!shardIds.contains(shardRoutingTable.shardId())) continue;
                targetShardSize += clusterInfo.getShardSize(shardRoutingTable.primaryShard(), 0L);
            }
        }
        return targetShardSize == 0L ? defaultValue : targetShardSize;
    }
}

