/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class AliasValidator {
    private AliasValidator() {
    }

    public static void validateAlias(Alias alias, String index, Metadata metadata) {
        AliasValidator.validateAlias(alias.name(), index, alias.indexRouting(), AliasValidator.lookup(metadata));
    }

    public static void validateAliasMetadata(AliasMetadata aliasMetadata, String index, Metadata metadata) {
        AliasValidator.validateAlias(aliasMetadata.alias(), index, aliasMetadata.indexRouting(), AliasValidator.lookup(metadata));
    }

    public static void validateAliasStandalone(Alias alias) {
        AliasValidator.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength(alias.filter())) {
            try {
                XContentHelper.convertToMap(XContentFactory.xContent((CharSequence)alias.filter()), alias.filter(), false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    public static void validateAlias(String alias, String index, @Nullable String indexRouting, Function<String, String> lookup) {
        AliasValidator.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("index name is required");
        }
        String sameNameAsAlias = lookup.apply(alias);
        if (sameNameAsAlias != null) {
            throw new InvalidAliasNameException(alias, "an index or data stream exists with the same name as the alias");
        }
    }

    static void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText(alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        MetadataCreateIndexService.validateIndexOrAliasName(alias, InvalidAliasNameException::new);
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new IllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public static void validateAliasFilter(String alias, String filter, SearchExecutionContext searchExecutionContext, NamedXContentRegistry xContentRegistry) {
        assert (searchExecutionContext != null);
        try (XContentParser parser = XContentFactory.xContent((CharSequence)filter).createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), filter);){
            AliasValidator.validateAliasFilter(parser, searchExecutionContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public static void validateAliasFilter(String alias, BytesReference filter, SearchExecutionContext searchExecutionContext, NamedXContentRegistry xContentRegistry) {
        assert (searchExecutionContext != null);
        try (StreamInput inputStream = filter.streamInput();
             XContentParser parser = XContentFactory.xContentType((InputStream)inputStream).xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (InputStream)filter.streamInput());){
            AliasValidator.validateAliasFilter(parser, searchExecutionContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    private static void validateAliasFilter(XContentParser parser, SearchExecutionContext searchExecutionContext) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseTopLevelQuery(parser);
        QueryBuilder queryBuilder = Rewriteable.rewrite(parseInnerQueryBuilder, searchExecutionContext, true);
        queryBuilder.toQuery(searchExecutionContext);
    }

    private static Function<String, String> lookup(Metadata metadata) {
        return name -> Optional.ofNullable((IndexAbstraction)metadata.getIndicesLookup().get(name)).filter(indexAbstraction -> indexAbstraction.getType() != IndexAbstraction.Type.ALIAS).map(IndexAbstraction::getName).orElse(null);
    }
}

