/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlocks
implements SimpleDiffable<ClusterBlocks> {
    private static final ClusterBlock[] EMPTY_BLOCKS_ARRAY = new ClusterBlock[0];
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK = new ClusterBlocks(Set.of(), Map.of());
    private final Set<ClusterBlock> global;
    private final Map<String, Set<ClusterBlock>> indicesBlocks;
    private final EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders;

    ClusterBlocks(Set<ClusterBlock> global, Map<String, Set<ClusterBlock>> indicesBlocks) {
        this.global = global;
        this.indicesBlocks = indicesBlocks;
        this.levelHolders = ClusterBlocks.generateLevelHolders(global, indicesBlocks);
    }

    public Set<ClusterBlock> global() {
        return this.global;
    }

    public Map<String, Set<ClusterBlock>> indices() {
        return this.indicesBlocks;
    }

    public Set<ClusterBlock> global(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).global();
    }

    public Map<String, Set<ClusterBlock>> indices(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).indices();
    }

    private Set<ClusterBlock> blocksForIndex(ClusterBlockLevel level, String index) {
        return this.indices(level).getOrDefault(index, Set.of());
    }

    private static EnumMap<ClusterBlockLevel, ImmutableLevelHolder> generateLevelHolders(Set<ClusterBlock> global, Map<String, Set<ClusterBlock>> indicesBlocks) {
        EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders = new EnumMap<ClusterBlockLevel, ImmutableLevelHolder>(ClusterBlockLevel.class);
        ArrayList<ClusterBlock> scratch = new ArrayList<ClusterBlock>();
        Map<String, Set<ClusterBlock>> indicesBuilder = Maps.newMapWithExpectedSize(indicesBlocks.size());
        for (ClusterBlockLevel level : ClusterBlockLevel.values()) {
            for (Map.Entry<String, Set<ClusterBlock>> entry : indicesBlocks.entrySet()) {
                indicesBuilder.put(entry.getKey(), ClusterBlocks.addBlocksAtLevel(entry.getValue(), scratch, level));
            }
            levelHolders.put(level, new ImmutableLevelHolder(ClusterBlocks.addBlocksAtLevel(global, scratch, level), Map.copyOf(indicesBuilder)));
            indicesBuilder.clear();
        }
        return levelHolders;
    }

    private static Set<ClusterBlock> addBlocksAtLevel(Set<ClusterBlock> blocks, List<ClusterBlock> scratch, ClusterBlockLevel level) {
        for (ClusterBlock clusterBlock : blocks) {
            if (!clusterBlock.contains(level)) continue;
            scratch.add(clusterBlock);
        }
        Set<ClusterBlock> res = Set.of(scratch.toArray(EMPTY_BLOCKS_ARRAY));
        scratch.clear();
        return res;
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains(block);
    }

    public boolean hasGlobalBlockWithId(int blockId) {
        for (ClusterBlock clusterBlock : this.global) {
            if (clusterBlock.id() != blockId) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlockWithLevel(ClusterBlockLevel level) {
        return this.global(level).size() > 0;
    }

    public boolean hasGlobalBlockWithStatus(RestStatus status) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexBlock(String index, ClusterBlock block) {
        return this.indicesBlocks.containsKey(index) && this.indicesBlocks.get(index).contains(block);
    }

    public boolean hasIndexBlockWithId(String index, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(index);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ClusterBlock getIndexBlockWithId(String index, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(index);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return clusterBlock;
            }
        }
        return null;
    }

    public void globalBlockedRaiseException(ClusterBlockLevel level) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(level);
        if (blockException != null) {
            throw blockException;
        }
    }

    private boolean globalBlocked(ClusterBlockLevel level) {
        return !this.global(level).isEmpty();
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level) {
        if (!this.globalBlocked(level)) {
            return null;
        }
        return new ClusterBlockException(this.global(level));
    }

    public void indexBlockedRaiseException(ClusterBlockLevel level, String index) throws ClusterBlockException {
        ClusterBlockException blockException = this.indexBlockedException(level, index);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException indexBlockedException(ClusterBlockLevel level, String index) {
        return this.indicesBlockedException(level, new String[]{index});
    }

    public boolean indexBlocked(ClusterBlockLevel level, String index) {
        return this.globalBlocked(level) || !this.blocksForIndex(level, index).isEmpty();
    }

    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level, String[] indices) {
        Set<ClusterBlock> globalLevelBlocks = this.global(level);
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set<ClusterBlock> indexBlocks = this.blocksForIndex(level, index);
            if (indexBlocks.isEmpty() && globalLevelBlocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(indexBlocks, globalLevelBlocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalLevelBlocks.isEmpty()) {
                return new ClusterBlockException(globalLevelBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public ClusterBlockException indicesAllowReleaseResources(String[] indices) {
        Set<ClusterBlock> globalBlocks = this.global(ClusterBlockLevel.METADATA_WRITE).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set blocks = Sets.union(globalBlocks, this.blocksForIndex(ClusterBlockLevel.METADATA_WRITE, index)).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
            if (blocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(globalBlocks, blocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalBlocks.isEmpty()) {
                return new ClusterBlockException(globalBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public String toString() {
        if (this.global.isEmpty() && this.indices().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("blocks: \n");
        if (!this.global.isEmpty()) {
            sb.append("   _global_:\n");
            for (ClusterBlock clusterBlock : this.global) {
                sb.append("      ").append(clusterBlock);
            }
        }
        for (Map.Entry entry : this.indices().entrySet()) {
            sb.append("   ").append((String)entry.getKey()).append(":\n");
            for (ClusterBlock block : (Set)entry.getValue()) {
                sb.append("      ").append(block);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ClusterBlocks.writeBlockSet(this.global, out);
        out.writeMap(this.indicesBlocks, (o, s) -> ClusterBlocks.writeBlockSet(s, o));
    }

    private static void writeBlockSet(Set<ClusterBlock> blocks, StreamOutput out) throws IOException {
        out.writeCollection(blocks);
    }

    public static ClusterBlocks readFrom(StreamInput in) throws IOException {
        Set<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
        Map<String, Set<ClusterBlock>> indicesBlocks = in.readImmutableMap(i -> i.readString().intern(), ClusterBlocks::readBlockSet);
        if (global.isEmpty() && indicesBlocks.isEmpty()) {
            return EMPTY_CLUSTER_BLOCK;
        }
        return new ClusterBlocks(global, indicesBlocks);
    }

    private static Set<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
        return in.readCollectionAsImmutableSet(ClusterBlock::new);
    }

    public static Diff<ClusterBlocks> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ClusterBlocks::readFrom, in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterBlocks blocks) {
        return ClusterBlocks.builder().blocks(blocks);
    }

    record ImmutableLevelHolder(Set<ClusterBlock> global, Map<String, Set<ClusterBlock>> indices) {
    }

    public static class Builder {
        private final Set<ClusterBlock> global = new HashSet<ClusterBlock>();
        private final Map<String, Set<ClusterBlock>> indices = new HashMap<String, Set<ClusterBlock>>();

        public Builder blocks(ClusterBlocks blocks) {
            this.global.addAll(blocks.global());
            for (Map.Entry<String, Set<ClusterBlock>> entry : blocks.indices().entrySet()) {
                if (!this.indices.containsKey(entry.getKey())) {
                    this.indices.put(entry.getKey(), new HashSet());
                }
                this.indices.get(entry.getKey()).addAll((Collection<ClusterBlock>)entry.getValue());
            }
            return this;
        }

        public Builder addBlocks(IndexMetadata indexMetadata) {
            String indexName = indexMetadata.getIndex().getName();
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                this.addIndexBlock(indexName, MetadataIndexStateService.INDEX_CLOSED_BLOCK);
            }
            if (IndexMetadata.INDEX_READ_ONLY_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_ONLY_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_WRITE_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_METADATA_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            return this;
        }

        public Builder updateBlocks(IndexMetadata indexMetadata) {
            this.indices.remove(indexMetadata.getIndex().getName());
            return this.addBlocks(indexMetadata);
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder removeGlobalBlock(int blockId) {
            this.global.removeIf(block -> block.id() == blockId);
            return this;
        }

        public Builder addIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                this.indices.put(index, new HashSet());
            }
            this.indices.get(index).add(block);
            return this;
        }

        public Builder removeIndexBlocks(String index) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.remove(index);
            return this;
        }

        public boolean hasIndexBlock(String index, ClusterBlock block) {
            return this.indices.getOrDefault(index, Set.of()).contains(block);
        }

        public Builder removeIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.get(index).remove(block);
            if (this.indices.get(index).isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public Builder removeIndexBlockWithId(String index, int blockId) {
            Set<ClusterBlock> indexBlocks = this.indices.get(index);
            if (indexBlocks == null) {
                return this;
            }
            indexBlocks.removeIf(block -> block.id() == blockId);
            if (indexBlocks.isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public ClusterBlocks build() {
            if (this.indices.isEmpty() && this.global.isEmpty()) {
                return EMPTY_CLUSTER_BLOCK;
            }
            HashMap indicesBuilder = new HashMap(this.indices.size());
            for (Map.Entry<String, Set<ClusterBlock>> entry : this.indices.entrySet()) {
                indicesBuilder.put(entry.getKey(), Set.copyOf((Collection)entry.getValue()));
            }
            return new ClusterBlocks(Set.copyOf(this.global), Map.copyOf(indicesBuilder));
        }
    }
}

