/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.bootstrap.Elasticsearch;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.bootstrap.Spawner;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.NodeValidationException;

class Bootstrap {
    private final PrintStream out;
    private final PrintStream err;
    private final ServerArgs args;
    private final Spawner spawner = new Spawner();
    private final SetOnce<SecureSettings> secureSettings = new SetOnce();
    private final SetOnce<Environment> nodeEnv = new SetOnce();

    Bootstrap(PrintStream out, PrintStream err, ServerArgs args) {
        this.out = out;
        this.err = err;
        this.args = args;
    }

    ServerArgs args() {
        return this.args;
    }

    Spawner spawner() {
        return this.spawner;
    }

    void setSecureSettings(SecureSettings secureSettings) {
        this.secureSettings.set((Object)secureSettings);
    }

    SecureSettings secureSettings() {
        return (SecureSettings)this.secureSettings.get();
    }

    void setEnvironment(Environment environment) {
        this.nodeEnv.set((Object)environment);
    }

    Environment environment() {
        return (Environment)this.nodeEnv.get();
    }

    void exitWithNodeValidationException(NodeValidationException e) {
        Logger logger = LogManager.getLogger(Elasticsearch.class);
        logger.error("node validation exception\n{}", (Object)e.getMessage());
        this.gracefullyExit(78);
    }

    void exitWithUnknownException(Throwable e) {
        Logger logger = LogManager.getLogger(Elasticsearch.class);
        logger.error("fatal exception while booting Elasticsearch", e);
        this.gracefullyExit(1);
    }

    private void gracefullyExit(int exitCode) {
        this.printLogsSuggestion();
        this.err.flush();
        Bootstrap.exit(exitCode);
    }

    @SuppressForbidden(reason="main exit path")
    static void exit(int exitCode) {
        System.exit(exitCode);
    }

    private void printLogsSuggestion() {
        String basePath = System.getProperty("es.logs.base_path");
        assert (basePath != null) : "logging wasn't initialized";
        this.err.println("ERROR: Elasticsearch did not exit normally - check the logs at " + basePath + System.getProperty("file.separator") + System.getProperty("es.logs.cluster_name") + ".log");
    }

    void sendCliMarker(char marker) {
        this.err.println(marker);
        this.err.flush();
    }

    void closeStreams() {
        this.out.close();
        this.err.close();
    }
}

