/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequestBuilder;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class UpdateRequestBuilder
extends InstanceShardOperationRequestBuilder<UpdateRequest, UpdateResponse, UpdateRequestBuilder>
implements WriteRequestBuilder<UpdateRequestBuilder> {
    public UpdateRequestBuilder(ElasticsearchClient client) {
        super(client, UpdateAction.INSTANCE, new UpdateRequest());
    }

    public UpdateRequestBuilder(ElasticsearchClient client, String index, String id) {
        super(client, UpdateAction.INSTANCE, new UpdateRequest(index, id));
    }

    public UpdateRequestBuilder setId(String id) {
        ((UpdateRequest)this.request).id(id);
        return this;
    }

    public UpdateRequestBuilder setRouting(String routing) {
        ((UpdateRequest)this.request).routing(routing);
        return this;
    }

    public UpdateRequestBuilder setScript(Script script) {
        ((UpdateRequest)this.request).script(script);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        ((UpdateRequest)this.request).fetchSource(include, exclude);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        ((UpdateRequest)this.request).fetchSource(includes, excludes);
        return this;
    }

    public UpdateRequestBuilder setFetchSource(boolean fetchSource) {
        ((UpdateRequest)this.request).fetchSource(fetchSource);
        return this;
    }

    public UpdateRequestBuilder setRetryOnConflict(int retryOnConflict) {
        ((UpdateRequest)this.request).retryOnConflict(retryOnConflict);
        return this;
    }

    public UpdateRequestBuilder setVersion(long version) {
        ((UpdateRequest)this.request).version(version);
        return this;
    }

    public UpdateRequestBuilder setVersionType(VersionType versionType) {
        ((UpdateRequest)this.request).versionType(versionType);
        return this;
    }

    public UpdateRequestBuilder setIfSeqNo(long seqNo) {
        ((UpdateRequest)this.request).setIfSeqNo(seqNo);
        return this;
    }

    public UpdateRequestBuilder setIfPrimaryTerm(long term) {
        ((UpdateRequest)this.request).setIfPrimaryTerm(term);
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((UpdateRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequestBuilder setDoc(IndexRequest indexRequest) {
        ((UpdateRequest)this.request).doc(indexRequest);
        return this;
    }

    public UpdateRequestBuilder setDoc(XContentBuilder source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source, XContentType contentType) {
        ((UpdateRequest)this.request).doc(source, contentType);
        return this;
    }

    public UpdateRequestBuilder setDoc(String source, XContentType xContentType) {
        ((UpdateRequest)this.request).doc(source, xContentType);
        return this;
    }

    public UpdateRequestBuilder setDoc(byte[] source, XContentType xContentType) {
        ((UpdateRequest)this.request).doc(source, xContentType);
        return this;
    }

    public UpdateRequestBuilder setDoc(byte[] source, int offset, int length, XContentType xContentType) {
        ((UpdateRequest)this.request).doc(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequestBuilder setDoc(Object ... source) {
        ((UpdateRequest)this.request).doc(source);
        return this;
    }

    public UpdateRequestBuilder setDoc(XContentType xContentType, Object ... source) {
        ((UpdateRequest)this.request).doc(xContentType, source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(IndexRequest indexRequest) {
        ((UpdateRequest)this.request).upsert(indexRequest);
        return this;
    }

    public UpdateRequestBuilder setUpsert(XContentBuilder source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source, XContentType contentType) {
        ((UpdateRequest)this.request).upsert(source, contentType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(String source, XContentType xContentType) {
        ((UpdateRequest)this.request).upsert(source, xContentType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(byte[] source, XContentType xContentType) {
        ((UpdateRequest)this.request).upsert(source, xContentType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(byte[] source, int offset, int length, XContentType xContentType) {
        ((UpdateRequest)this.request).upsert(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequestBuilder setUpsert(Object ... source) {
        ((UpdateRequest)this.request).upsert(source);
        return this;
    }

    public UpdateRequestBuilder setUpsert(XContentType xContentType, Object ... source) {
        ((UpdateRequest)this.request).upsert(xContentType, source);
        return this;
    }

    public UpdateRequestBuilder setDocAsUpsert(boolean shouldUpsertDoc) {
        ((UpdateRequest)this.request).docAsUpsert(shouldUpsertDoc);
        return this;
    }

    public UpdateRequestBuilder setDetectNoop(boolean detectNoop) {
        ((UpdateRequest)this.request).detectNoop(detectNoop);
        return this;
    }

    public UpdateRequestBuilder setScriptedUpsert(boolean scriptedUpsert) {
        ((UpdateRequest)this.request).scriptedUpsert(scriptedUpsert);
        return this;
    }
}

