/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportResponse;

public final class ChannelActionListener<Response extends TransportResponse>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(ChannelActionListener.class);
    private final TransportChannel channel;

    public ChannelActionListener(TransportChannel channel) {
        this.channel = channel;
    }

    @Override
    public void onResponse(Response response) {
        ((TransportMessage)response).incRef();
        ActionListener.run(this, l -> l.channel.sendResponse((TransportResponse)response));
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (Exception sendException) {
            sendException.addSuppressed(e);
            logger.warn(() -> Strings.format((String)"Failed to send error response on channel [%s]", (Object[])new Object[]{this.channel}), (Throwable)sendException);
        }
    }

    public String toString() {
        return "ChannelActionListener{" + this.channel + "}";
    }
}

