/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;

final class CountedCollector<R extends SearchPhaseResult> {
    private final SearchPhaseResults<R> resultConsumer;
    private final CountDown counter;
    private final Runnable onFinish;
    private final SearchPhaseContext context;

    CountedCollector(SearchPhaseResults<R> resultConsumer, int expectedOps, Runnable onFinish, SearchPhaseContext context) {
        this.resultConsumer = resultConsumer;
        resultConsumer.incRef();
        this.counter = new CountDown(expectedOps);
        this.onFinish = onFinish;
        this.context = context;
    }

    void countDown() {
        assert (!this.counter.isCountedDown()) : "more operations executed than specified";
        if (this.counter.countDown()) {
            try {
                this.onFinish.run();
            }
            finally {
                this.resultConsumer.decRef();
            }
        }
    }

    void onResult(R result) {
        this.resultConsumer.consumeResult(result, this::countDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        try {
            this.context.onShardFailure(shardIndex, shardTarget, e);
        }
        finally {
            this.countDown();
        }
    }
}

