/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.AutoCreateAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private static final Logger logger = LogManager.getLogger(TransportBulkAction.class);
    private final ActionType<BulkResponse> bulkAction;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IngestService ingestService;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private static final String DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID = "auto-generated";
    private final IndexingPressure indexingPressure;
    private final SystemIndices systemIndices;

    @Inject
    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        this(threadPool, transportService, clusterService, ingestService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, System::nanoTime);
    }

    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider) {
        this(BulkAction.INSTANCE, BulkRequest::new, threadPool, transportService, clusterService, ingestService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, relativeTimeProvider);
    }

    TransportBulkAction(ActionType<BulkResponse> bulkAction, Writeable.Reader<BulkRequest> requestReader, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider) {
        super(bulkAction.name(), transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        Objects.requireNonNull(relativeTimeProvider);
        this.bulkAction = bulkAction;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        clusterService.addStateApplier(this.ingestForwarder);
    }

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    public static <Response extends ReplicationResponse> ActionListener<BulkResponse> unwrappingSingleItemBulkResponse(ActionListener<Response> listener) {
        return listener.delegateFailureAndWrap((l, bulkItemResponses) -> {
            assert (bulkItemResponses.getItems().length == 1) : "expected exactly one item in bulk response";
            BulkItemResponse bulkItemResponse = bulkItemResponses.getItems()[0];
            if (!bulkItemResponse.isFailed()) {
                Object response = bulkItemResponse.getResponse();
                l.onResponse(response);
            } else {
                l.onFailure(bulkItemResponse.getFailure().getCause());
            }
        });
    }

    @Override
    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        int indexingOps = bulkRequest.numberOfActions();
        long indexingBytes = bulkRequest.ramBytesUsed();
        boolean isOnlySystem = TransportBulkAction.isOnlySystem(bulkRequest, this.clusterService.state().metadata().getIndicesLookup(), this.systemIndices);
        Releasable releasable = this.indexingPressure.markCoordinatingOperationStarted(indexingOps, indexingBytes, isOnlySystem);
        ActionListener<BulkResponse> releasingListener = ActionListener.runBefore(listener, () -> ((Releasable)releasable).close());
        String executorName = isOnlySystem ? "system_write" : "write";
        this.ensureClusterStateThenForkAndExecute(task, bulkRequest, executorName, releasingListener);
    }

    private void ensureClusterStateThenForkAndExecute(final Task task, final BulkRequest bulkRequest, final String executorName, final ActionListener<BulkResponse> releasingListener) {
        ClusterState initialState = this.clusterService.state();
        final ClusterBlockException blockException = initialState.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
        if (blockException != null) {
            if (!blockException.retryable()) {
                releasingListener.onFailure(blockException);
                return;
            }
            logger.trace("cluster is blocked, waiting for it to recover", (Throwable)blockException);
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, bulkRequest.timeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportBulkAction.this.forkAndExecute(task, bulkRequest, executorName, releasingListener);
                }

                @Override
                public void onClusterServiceClose() {
                    releasingListener.onFailure(new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    releasingListener.onFailure(blockException);
                }
            }, newState -> false == newState.blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.WRITE));
        } else {
            this.forkAndExecute(task, bulkRequest, executorName, releasingListener);
        }
    }

    private void forkAndExecute(final Task task, final BulkRequest bulkRequest, final String executorName, final ActionListener<BulkResponse> releasingListener) {
        this.threadPool.executor("write").execute(new ActionRunnable<BulkResponse>(releasingListener){

            @Override
            protected void doRun() {
                TransportBulkAction.this.doInternalExecute(task, bulkRequest, executorName, releasingListener);
            }
        });
    }

    protected void doInternalExecute(Task task, BulkRequest bulkRequest, String executorName, ActionListener<BulkResponse> listener) {
        long startTime = this.relativeTime();
        boolean hasIndexRequestsWithPipelines = false;
        Metadata metadata = this.clusterService.state().getMetadata();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest ir;
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                IngestService.resolvePipelinesAndUpdateIndexRequest(actionRequest, indexRequest, metadata);
                hasIndexRequestsWithPipelines |= IngestService.hasPipeline(indexRequest);
            }
            if (!(actionRequest instanceof IndexRequest) || (ir = (IndexRequest)actionRequest).getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            ActionListener.run(listener, l -> {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executorName, (ActionListener<BulkResponse>)l);
                } else {
                    this.ingestForwarder.forwardIngestRequest(this.bulkAction, bulkRequest, (ActionListener<?>)l);
                }
            });
            return;
        }
        Map<String, Boolean> indices = bulkRequest.requests.stream().filter(request -> request.opType() != DocWriteRequest.OpType.DELETE || request.versionType() == VersionType.EXTERNAL || request.versionType() == VersionType.EXTERNAL_GTE).collect(Collectors.toMap(DocWriteRequest::index, DocWriteRequest::isRequireAlias, (v1, v2) -> v1 != false || v2 != false));
        HashMap<String, IndexNotFoundException> indicesThatCannotBeCreated = new HashMap<String, IndexNotFoundException>();
        HashSet<String> autoCreateIndices = new HashSet<String>();
        ClusterState state = this.clusterService.state();
        for (Map.Entry<String, Boolean> indexAndFlag : indices.entrySet()) {
            String index = indexAndFlag.getKey();
            boolean shouldAutoCreate = !this.indexNameExpressionResolver.hasIndexAbstraction(index, state);
            if (!shouldAutoCreate || indexAndFlag.getValue().booleanValue()) continue;
            autoCreateIndices.add(index);
        }
        this.createMissingIndicesAndIndexData(task, bulkRequest, executorName, listener, autoCreateIndices, indicesThatCannotBeCreated, startTime);
    }

    protected void createMissingIndicesAndIndexData(final Task task, final BulkRequest bulkRequest, final String executorName, final ActionListener<BulkResponse> listener, Set<String> autoCreateIndices, final Map<String, IndexNotFoundException> indicesThatCannotBeCreated, final long startTime) {
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (autoCreateIndices.isEmpty()) {
            this.executeBulk(task, bulkRequest, startTime, listener, executorName, responses, indicesThatCannotBeCreated);
        } else {
            final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
            for (final String index : autoCreateIndices) {
                this.createIndex(index, bulkRequest.timeout(), new ActionListener<CreateIndexResponse>(){

                    @Override
                    public void onResponse(CreateIndexResponse result) {
                        if (counter.decrementAndGet() == 0) {
                            this.forkExecuteBulk(listener);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        Throwable cause = ExceptionsHelper.unwrapCause(e);
                        if (cause instanceof IndexNotFoundException) {
                            IndexNotFoundException indexNotFoundException = (IndexNotFoundException)cause;
                            Map map = indicesThatCannotBeCreated;
                            synchronized (map) {
                                indicesThatCannotBeCreated.put(index, indexNotFoundException);
                            }
                        } else if (!(cause instanceof ResourceAlreadyExistsException)) {
                            for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                DocWriteRequest<?> request = bulkRequest.requests.get(i);
                                if (request == null || !TransportBulkAction.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                bulkRequest.requests.set(i, null);
                            }
                        }
                        if (counter.decrementAndGet() == 0) {
                            this.forkExecuteBulk(ActionListener.wrap(listener::onResponse, inner -> {
                                inner.addSuppressed(e);
                                listener.onFailure((Exception)inner);
                            }));
                        }
                    }

                    private void forkExecuteBulk(ActionListener<BulkResponse> finalListener) {
                        TransportBulkAction.this.threadPool.executor(executorName).execute(new ActionRunnable<BulkResponse>(finalListener){

                            @Override
                            protected void doRun() {
                                TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, this.listener, executorName, responses, indicesThatCannotBeCreated);
                            }
                        });
                    }
                });
            }
        }
    }

    protected IngestService getIngestService(BulkRequest request) {
        return this.ingestService;
    }

    static void prohibitAppendWritesInBackingIndices(DocWriteRequest<?> writeRequest, Metadata metadata) {
        DocWriteRequest.OpType opType = writeRequest.opType();
        if (!(opType == DocWriteRequest.OpType.CREATE || opType == DocWriteRequest.OpType.INDEX)) {
            return;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            return;
        }
        if (indexAbstraction.getParentDataStream() == null) {
            return;
        }
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (opType == DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("index request with op_type=create targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
        if (opType == DocWriteRequest.OpType.INDEX && writeRequest.ifPrimaryTerm() == 0L && writeRequest.ifSeqNo() == -2L) {
            throw new IllegalArgumentException("index request with op_type=index and no if_primary_term and if_seq_no set targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
    }

    static void prohibitCustomRoutingOnDataStream(DocWriteRequest<?> writeRequest, Metadata metadata) {
        DataStream dataStream;
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) {
            return;
        }
        if (writeRequest.routing() != null && !(dataStream = (DataStream)indexAbstraction).isAllowCustomRouting()) {
            throw new IllegalArgumentException("index request targeting data stream [" + dataStream.getName() + "] specifies a custom routing but the [allow_custom_routing] setting was not enabled in the data stream's template.");
        }
    }

    static boolean isOnlySystem(BulkRequest request, SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices) {
        return request.getIndices().stream().allMatch(indexName -> TransportBulkAction.isSystemIndex(indicesLookup, systemIndices, indexName));
    }

    private static boolean isSystemIndex(SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices, String indexName) {
        IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(indexName);
        if (abstraction != null) {
            return abstraction.isSystem();
        }
        return systemIndices.isSystemIndex(indexName);
    }

    void createIndex(String index, TimeValue timeout, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest();
        createIndexRequest.index(index);
        createIndexRequest.cause("auto(bulk api)");
        createIndexRequest.masterNodeTimeout(timeout);
        this.client.execute(AutoCreateAction.INSTANCE, createIndexRequest, listener);
    }

    private static boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, DocWriteRequest<?> request, String index, Exception e) {
        if (index.equals(request.index())) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.id(), e);
            responses.set(idx, BulkItemResponse.failure(idx, request.opType(), failure));
            return true;
        }
        return false;
    }

    protected long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, String executorName, AtomicArray<BulkItemResponse> responses, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
        new BulkOperation(task, bulkRequest, listener, executorName, responses, startTimeNanos, indicesThatCannotBeCreated).run();
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final String executorName, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.getIngestService(original).executeBulkRequest(original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsDropped, bulkRequestModifier::markItemAsFailed, (originalThread, exception) -> {
            if (exception != null) {
                logger.debug("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    ActionRunnable<BulkResponse> runnable = new ActionRunnable<BulkResponse>(actionListener){

                        @Override
                        protected void doRun() {
                            TransportBulkAction.this.doInternalExecute(task, bulkRequest, executorName, actionListener);
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }
                    };
                    if (originalThread == Thread.currentThread()) {
                        runnable.run();
                    } else {
                        this.threadPool.executor(executorName).execute(runnable);
                    }
                }
            }
        }, executorName);
    }

    private final class BulkOperation
    extends ActionRunnable<BulkResponse> {
        private final Task task;
        private BulkRequest bulkRequest;
        private final ActionListener<BulkResponse> listener;
        private final AtomicArray<BulkItemResponse> responses;
        private final long startTimeNanos;
        private final ClusterStateObserver observer;
        private final Map<String, IndexNotFoundException> indicesThatCannotBeCreated;
        private final String executorName;

        BulkOperation(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener, String executorName, AtomicArray<BulkItemResponse> responses, long startTimeNanos, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
            super(listener);
            this.task = task;
            this.bulkRequest = bulkRequest;
            this.listener = listener;
            this.responses = responses;
            this.startTimeNanos = startTimeNanos;
            this.indicesThatCannotBeCreated = indicesThatCannotBeCreated;
            this.executorName = executorName;
            this.observer = new ClusterStateObserver(TransportBulkAction.this.clusterService, bulkRequest.timeout(), logger, TransportBulkAction.this.threadPool.getThreadContext());
        }

        @Override
        protected void doRun() {
            assert (this.bulkRequest != null);
            ClusterState clusterState = this.observer.setAndGetObservedState();
            if (this.handleBlockExceptions(clusterState)) {
                return;
            }
            ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, TransportBulkAction.this.indexNameExpressionResolver);
            Metadata metadata = clusterState.metadata();
            HashMap<ShardId, List> requestsByShard = new HashMap<ShardId, List>();
            for (int i = 0; i < this.bulkRequest.requests.size(); ++i) {
                DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests.get(i);
                if (docWriteRequest == null || this.addFailureIfRequiresAliasAndAliasIsMissing(docWriteRequest, i, metadata) || this.addFailureIfIndexCannotBeCreated(docWriteRequest, i)) continue;
                IndexAbstraction ia = null;
                boolean includeDataStreams = docWriteRequest.opType() == DocWriteRequest.OpType.CREATE;
                try {
                    ia = concreteIndices.resolveIfAbsent(docWriteRequest);
                    if (ia.isDataStreamRelated() && !includeDataStreams) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    if (ia.getParentDataStream() != null && !ia.getName().equals(docWriteRequest.index()) && docWriteRequest.opType() != DocWriteRequest.OpType.CREATE) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    TransportBulkAction.prohibitCustomRoutingOnDataStream(docWriteRequest, metadata);
                    TransportBulkAction.prohibitAppendWritesInBackingIndices(docWriteRequest, metadata);
                    docWriteRequest.routing(metadata.resolveWriteIndexRouting(docWriteRequest.routing(), docWriteRequest.index()));
                    Index concreteIndex = docWriteRequest.getConcreteWriteIndex(ia, metadata);
                    if (this.addFailureIfIndexIsClosed(docWriteRequest, concreteIndex, i, metadata)) continue;
                    IndexRouting indexRouting = concreteIndices.routing(concreteIndex);
                    docWriteRequest.process(indexRouting);
                    int shardId = docWriteRequest.route(indexRouting);
                    List shardRequests = requestsByShard.computeIfAbsent(new ShardId(concreteIndex, shardId), shard -> new ArrayList());
                    shardRequests.add(new BulkItemRequest(i, docWriteRequest));
                    continue;
                }
                catch (IllegalArgumentException | ElasticsearchParseException | ResourceNotFoundException | RoutingMissingException e) {
                    String name = ia != null ? ia.getName() : docWriteRequest.index();
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(name, docWriteRequest.id(), e);
                    BulkItemResponse bulkItemResponse = BulkItemResponse.failure(i, docWriteRequest.opType(), failure);
                    this.responses.set(i, bulkItemResponse);
                    this.bulkRequest.requests.set(i, null);
                }
            }
            if (requestsByShard.isEmpty()) {
                this.listener.onResponse(new BulkResponse(this.responses.toArray((BulkItemResponse[])new BulkItemResponse[this.responses.length()]), TransportBulkAction.this.buildTookInMillis(this.startTimeNanos)));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
            String nodeId = TransportBulkAction.this.clusterService.localNode().getId();
            for (Map.Entry entry : requestsByShard.entrySet()) {
                ShardId shardId = (ShardId)entry.getKey();
                final List requests = (List)entry.getValue();
                BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, this.bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[0]));
                bulkShardRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
                bulkShardRequest.timeout(this.bulkRequest.timeout());
                bulkShardRequest.routedBasedOnClusterVersion(clusterState.version());
                if (this.task != null) {
                    bulkShardRequest.setParentTask(nodeId, this.task.getId());
                }
                TransportBulkAction.this.client.executeLocally(TransportShardBulkAction.TYPE, bulkShardRequest, new ActionListener<BulkShardResponse>(){

                    @Override
                    public void onResponse(BulkShardResponse bulkShardResponse) {
                        for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                            if (bulkItemResponse.getResponse() != null) {
                                ((ReplicationResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                            }
                            BulkOperation.this.responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                        }
                        this.maybeFinishHim();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        for (BulkItemRequest request : requests) {
                            String indexName = request.index();
                            DocWriteRequest<?> docWriteRequest = request.request();
                            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexName, docWriteRequest.id(), e);
                            BulkOperation.this.responses.set(request.id(), BulkItemResponse.failure(request.id(), docWriteRequest.opType(), failure));
                        }
                        this.maybeFinishHim();
                    }

                    private void maybeFinishHim() {
                        if (counter.decrementAndGet() == 0) {
                            BulkOperation.this.listener.onResponse(new BulkResponse(BulkOperation.this.responses.toArray((BulkItemResponse[])new BulkItemResponse[BulkOperation.this.responses.length()]), TransportBulkAction.this.buildTookInMillis(BulkOperation.this.startTimeNanos)));
                        }
                    }
                });
            }
            this.bulkRequest = null;
        }

        private boolean handleBlockExceptions(ClusterState state) {
            ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
            if (blockException != null) {
                if (blockException.retryable()) {
                    logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry(blockException);
                } else {
                    this.onFailure(blockException);
                }
                return true;
            }
            return false;
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.onFailure(failure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    this.dispatchRetry();
                }

                @Override
                public void onClusterServiceClose() {
                    BulkOperation.this.onFailure(new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    this.dispatchRetry();
                }

                private void dispatchRetry() {
                    TransportBulkAction.this.threadPool.executor(BulkOperation.this.executorName).submit(BulkOperation.this);
                }
            });
        }

        private boolean addFailureIfRequiresAliasAndAliasIsMissing(DocWriteRequest<?> request, int idx, Metadata metadata) {
            if (request.isRequireAlias() && !metadata.hasAlias(request.index())) {
                IndexNotFoundException exception = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
                this.addFailure(request, idx, exception);
                return true;
            }
            return false;
        }

        private boolean addFailureIfIndexIsClosed(DocWriteRequest<?> request, Index concreteIndex, int idx, Metadata metadata) {
            IndexMetadata indexMetadata = metadata.getIndexSafe(concreteIndex);
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                this.addFailure(request, idx, new IndexClosedException(concreteIndex));
                return true;
            }
            return false;
        }

        private boolean addFailureIfIndexCannotBeCreated(DocWriteRequest<?> request, int idx) {
            IndexNotFoundException cannotCreate = this.indicesThatCannotBeCreated.get(request.index());
            if (cannotCreate != null) {
                this.addFailure(request, idx, cannotCreate);
                return true;
            }
            return false;
        }

        private void addFailure(DocWriteRequest<?> request, int idx, Exception unavailableException) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.id(), unavailableException);
            BulkItemResponse bulkItemResponse = BulkItemResponse.failure(idx, request.opType(), failure);
            this.responses.set(idx, bulkItemResponse);
            this.bulkRequest.requests.set(idx, null);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<DocWriteRequest<?>> {
        final BulkRequest bulkRequest;
        final SparseFixedBitSet failedSlots;
        final List<BulkItemResponse> itemResponses;
        final AtomicIntegerArray originalSlots;
        volatile int currentSlot = -1;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
            this.originalSlots = new AtomicIntegerArray(bulkRequest.requests().size());
        }

        @Override
        public DocWriteRequest<?> next() {
            return this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            List<DocWriteRequest<?>> requests = this.bulkRequest.requests();
            for (int i = 0; i < requests.size(); ++i) {
                DocWriteRequest<?> request = requests.get(i);
                if (this.failedSlots.get(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots.set(slot++, i);
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return actionListener.map(response -> new BulkResponse(response.getItems(), response.getTook().getMillis(), ingestTookInMillis));
            }
            return actionListener.map(response -> {
                BulkItemResponse[] bulkResponses = response.getItems();
                BulkItemResponse[] allResponses = new BulkItemResponse[bulkResponses.length + this.itemResponses.size()];
                Iterator<BulkItemResponse> iterator = this.itemResponses.iterator();
                while (iterator.hasNext()) {
                    BulkItemResponse item;
                    allResponses[item.getItemId()] = item = iterator.next();
                }
                for (int i = 0; i < bulkResponses.length; ++i) {
                    allResponses[this.originalSlots.get((int)i)] = bulkResponses[i];
                }
                if (Assertions.ENABLED) {
                    this.assertResponsesAreCorrect(bulkResponses, allResponses);
                }
                return new BulkResponse(allResponses, response.getTook().getMillis(), ingestTookInMillis);
            });
        }

        private void assertResponsesAreCorrect(BulkItemResponse[] bulkResponses, BulkItemResponse[] allResponses) {
            Set failedIds = this.itemResponses.stream().map(BulkItemResponse::getItemId).collect(Collectors.toSet());
            Set responseIds = IntStream.range(0, bulkResponses.length).map(this.originalSlots::get).boxed().collect(Collectors.toSet());
            assert (Sets.haveEmptyIntersection(failedIds, responseIds)) : "bulk item response slots cannot have failed and been processed in the subsequent bulk request, failed ids: " + failedIds + ", response ids: " + responseIds;
            int expectedResponseCount = this.bulkRequest.requests.size();
            int actualResponseCount = failedIds.size() + responseIds.size();
            assert (expectedResponseCount == actualResponseCount) : "Expected [" + expectedResponseCount + "] responses, but found [" + actualResponseCount + "]";
            for (int i = 0; i < allResponses.length; ++i) {
                assert (allResponses[i] != null) : "BulkItemResponse at index [" + i + "] was null";
            }
        }

        synchronized void markItemAsFailed(int slot, Exception e) {
            DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests().get(slot);
            String id = Objects.requireNonNullElse(docWriteRequest.id(), TransportBulkAction.DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID);
            this.failedSlots.set(slot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(docWriteRequest.index(), id, e);
            this.itemResponses.add(BulkItemResponse.failure(slot, docWriteRequest.opType(), failure));
        }

        synchronized void markItemAsDropped(int slot) {
            DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests().get(slot);
            String id = Objects.requireNonNullElse(docWriteRequest.id(), TransportBulkAction.DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID);
            this.failedSlots.set(slot);
            UpdateResponse dropped = new UpdateResponse(new ShardId(docWriteRequest.index(), "_na_", 0), id, -2L, 0L, docWriteRequest.version(), DocWriteResponse.Result.NOOP);
            this.itemResponses.add(BulkItemResponse.success(slot, docWriteRequest.opType(), dropped));
        }
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, IndexAbstraction> indexAbstractions = new HashMap<String, IndexAbstraction>();
        private final Map<Index, IndexRouting> routings = new HashMap<Index, IndexRouting>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        IndexAbstraction resolveIfAbsent(DocWriteRequest<?> request) {
            try {
                return this.indexAbstractions.computeIfAbsent(request.index(), key -> this.indexNameExpressionResolver.resolveWriteIndexAbstraction(this.state, request));
            }
            catch (IndexNotFoundException e) {
                if (e.getMetadataKeys().contains("es.excluded_ds")) {
                    throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams", e);
                }
                throw e;
            }
        }

        IndexRouting routing(Index index) {
            return this.routings.computeIfAbsent(index, idx -> IndexRouting.fromIndexMetadata(this.state.metadata().getIndexSafe((Index)idx)));
        }
    }
}

