/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class ProjectExec
extends UnaryExec {
    private final List<? extends NamedExpression> projections;

    public ProjectExec(Source source, PhysicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    protected NodeInfo<ProjectExec> info() {
        return NodeInfo.create((Node)this, ProjectExec::new, (Object)((Object)this.child()), this.projections);
    }

    @Override
    public ProjectExec replaceChild(PhysicalPlan newChild) {
        return new ProjectExec(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.projections, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ProjectExec other = (ProjectExec)((Object)obj);
        return Objects.equals(this.projections, other.projections) && Objects.equals((Object)this.child(), (Object)other.child());
    }
}

