/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Eval
extends UnaryPlan {
    private final List<Alias> fields;
    private List<Attribute> lazyOutput;

    public Eval(Source source, LogicalPlan child, List<Alias> fields) {
        super(source, child);
        this.fields = fields;
    }

    public List<Alias> fields() {
        return this.fields;
    }

    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.fields, this.child().output());
        }
        return this.lazyOutput;
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.fields);
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Eval(this.source(), newChild, this.fields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Eval::new, (Object)this.child(), this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Eval eval = (Eval)((Object)o);
        return this.child().equals((Object)eval.child()) && Objects.equals(this.fields, eval.fields);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

