/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.MulUnsignedLongsEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Mul
extends EsqlArithmeticOperation
implements BinaryComparisonInversible {
    public Mul(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MUL, MulIntsEvaluator.Factory::new, MulLongsEvaluator.Factory::new, MulUnsignedLongsEvaluator.Factory::new, (s, lhs, rhs) -> new MulDoublesEvaluator.Factory(source, lhs, rhs));
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (DataTypes.isNullOrNumeric((DataType)l) && DataTypes.isNullOrNumeric((DataType)r)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Div::new;
    }

    protected boolean isCommutative() {
        return true;
    }

    public Mul swapLeftAndRight() {
        return new Mul(this.source(), this.right(), this.left());
    }

    protected NodeInfo<Mul> info() {
        return NodeInfo.create((Node)this, Mul::new, (Object)this.left(), (Object)this.right());
    }

    protected Mul replaceChildren(Expression left, Expression right) {
        return new Mul(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.multiplyExact(lhs, rhs);
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongMultiplyExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs * rhs;
    }
}

