/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsFinite;
import org.elasticsearch.xpack.ql.tree.Source;

public final class IsFiniteEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;

    public IsFiniteEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.val = val;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock valBlock = (DoubleBlock)this.val.eval(page);){
            DoubleVector valVector = valBlock.asVector();
            if (valVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), valBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, DoubleBlock valBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(IsFinite.process(valBlock.getDouble(valBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, DoubleVector valVector) {
        try (BooleanVector.Builder result = this.driverContext.blockFactory().newBooleanVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(IsFinite.process(valVector.getDouble(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "IsFiniteEvaluator[val=" + this.val + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val) {
            this.source = source;
            this.val = val;
        }

        public IsFiniteEvaluator get(DriverContext context) {
            return new IsFiniteEvaluator(this.source, this.val.get(context), context);
        }

        public String toString() {
            return "IsFiniteEvaluator[val=" + this.val + "]";
        }
    }
}

