/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;
import org.elasticsearch.xpack.ql.tree.Source;

public final class DateFormatConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator val;
    private final DateFormatter formatter;
    private final DriverContext driverContext;

    public DateFormatConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DateFormatter formatter, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.val = val;
        this.formatter = formatter;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valBlock = (LongBlock)this.val.eval(page);){
            LongVector valVector = valBlock.asVector();
            if (valVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, LongBlock valBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(DateFormat.process(valBlock.getLong(valBlock.getFirstValueIndex(p)), this.formatter));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, LongVector valVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(DateFormat.process(valVector.getLong(p), this.formatter));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "DateFormatConstantEvaluator[val=" + this.val + ", formatter=" + this.formatter + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final DateFormatter formatter;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, DateFormatter formatter) {
            this.source = source;
            this.val = val;
            this.formatter = formatter;
        }

        public DateFormatConstantEvaluator get(DriverContext context) {
            return new DateFormatConstantEvaluator(this.source, this.val.get(context), this.formatter, context);
        }

        public String toString() {
            return "DateFormatConstantEvaluator[val=" + this.val + ", formatter=" + this.formatter + "]";
        }
    }
}

