/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromStringEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToUnsignedLong
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.UNSIGNED_LONG, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.DATETIME, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataTypes.BOOLEAN, ToUnsignedLongFromBooleanEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToUnsignedLongFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.LONG, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToUnsignedLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"unsigned_long"})
    public ToUnsignedLong(Source source, @Param(name="v", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.UNSIGNED_LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToUnsignedLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToUnsignedLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? NumericUtils.ONE_AS_UNSIGNED_LONG : NumericUtils.ZERO_AS_UNSIGNED_LONG;
    }

    static long fromKeyword(BytesRef in) {
        String asString = in.utf8ToString();
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((String)asString));
    }

    static long fromDouble(double dbl) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Double)dbl));
    }

    static long fromLong(long lng) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Long)lng));
    }

    static long fromInt(int i) {
        return ToUnsignedLong.fromLong(i);
    }
}

