/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToInteger
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.INTEGER, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.BOOLEAN, ToIntegerFromBooleanEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, ToIntegerFromLongEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToIntegerFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, ToIntegerFromUnsignedLongEvaluator.Factory::new), Map.entry(DataTypes.LONG, ToIntegerFromLongEvaluator.Factory::new));

    @FunctionInfo(returnType={"integer"})
    public ToInteger(Source source, @Param(name="v", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToInteger(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToInteger::new, (Object)this.field());
    }

    static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }

    static int fromKeyword(BytesRef in) {
        String asString = in.utf8ToString();
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException nfe) {
            try {
                return ToInteger.fromDouble(Double.parseDouble(asString));
            }
            catch (Exception e) {
                throw nfe;
            }
        }
    }

    static int fromDouble(double dbl) {
        return DataTypeConverter.safeToInt((double)dbl);
    }

    static int fromUnsignedLong(long ul) {
        Number n = NumericUtils.unsignedLongAsNumber((long)ul);
        int i = n.intValue();
        if ((long)i != n.longValue()) {
            throw new InvalidArgumentException("[{}] out of [integer] range", new Object[]{n});
        }
        return i;
    }

    static int fromLong(long lng) {
        return DataTypeConverter.safeToInt((long)lng);
    }
}

