/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class ComparisonMapper<T extends BinaryComparison>
extends ExpressionMapper<T> {
    public static final ExpressionMapper<?> EQUALS = new ComparisonMapper<Equals>(EqualsIntsEvaluator.Factory::new, EqualsLongsEvaluator.Factory::new, EqualsDoublesEvaluator.Factory::new, EqualsKeywordsEvaluator.Factory::new, EqualsBoolsEvaluator.Factory::new){};
    public static final ExpressionMapper<?> NOT_EQUALS = new ComparisonMapper<NotEquals>(NotEqualsIntsEvaluator.Factory::new, NotEqualsLongsEvaluator.Factory::new, NotEqualsDoublesEvaluator.Factory::new, NotEqualsKeywordsEvaluator.Factory::new, NotEqualsBoolsEvaluator.Factory::new){};
    public static final ExpressionMapper<?> GREATER_THAN = new ComparisonMapper<GreaterThan>(GreaterThanIntsEvaluator.Factory::new, GreaterThanLongsEvaluator.Factory::new, GreaterThanDoublesEvaluator.Factory::new, GreaterThanKeywordsEvaluator.Factory::new){};
    public static final ExpressionMapper<?> GREATER_THAN_OR_EQUAL = new ComparisonMapper<GreaterThanOrEqual>(GreaterThanOrEqualIntsEvaluator.Factory::new, GreaterThanOrEqualLongsEvaluator.Factory::new, GreaterThanOrEqualDoublesEvaluator.Factory::new, GreaterThanOrEqualKeywordsEvaluator.Factory::new){};
    public static final ExpressionMapper<?> LESS_THAN = new ComparisonMapper<LessThan>(LessThanIntsEvaluator.Factory::new, LessThanLongsEvaluator.Factory::new, LessThanDoublesEvaluator.Factory::new, LessThanKeywordsEvaluator.Factory::new){};
    public static final ExpressionMapper<?> LESS_THAN_OR_EQUAL = new ComparisonMapper<LessThanOrEqual>(LessThanOrEqualIntsEvaluator.Factory::new, LessThanOrEqualLongsEvaluator.Factory::new, LessThanOrEqualDoublesEvaluator.Factory::new, LessThanOrEqualKeywordsEvaluator.Factory::new){};
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> ints;
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> longs;
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> doubles;
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> keywords;
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> bools;

    private ComparisonMapper(TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> ints, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> longs, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> doubles, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> keywords, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> bools) {
        this.ints = ints;
        this.longs = longs;
        this.doubles = doubles;
        this.keywords = keywords;
        this.bools = bools;
    }

    ComparisonMapper(TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> ints, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> longs, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> doubles, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> keywords) {
        this.ints = ints;
        this.longs = longs;
        this.doubles = doubles;
        this.keywords = keywords;
        this.bools = (source, lhs, rhs) -> {
            throw EsqlIllegalArgumentException.illegalDataType(DataTypes.BOOLEAN);
        };
    }

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory map(BinaryComparison bc, Layout layout) {
        DataType leftType = bc.left().dataType();
        if (leftType.isNumeric()) {
            DataType type = EsqlDataTypeRegistry.INSTANCE.commonType(leftType, bc.right().dataType());
            if (type == DataTypes.INTEGER) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.INTEGER, this.ints);
            }
            if (type == DataTypes.LONG) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.LONG, this.longs);
            }
            if (type == DataTypes.DOUBLE) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.DOUBLE, this.doubles);
            }
            if (type == DataTypes.UNSIGNED_LONG) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.UNSIGNED_LONG, this.longs);
            }
        }
        EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(bc.left(), layout);
        EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(bc.right(), layout);
        if (leftType == DataTypes.KEYWORD || leftType == DataTypes.TEXT || leftType == DataTypes.IP || leftType == DataTypes.VERSION) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.keywords.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        if (leftType == DataTypes.BOOLEAN) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.bools.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        if (leftType == DataTypes.DATETIME) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.longs.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        if (leftType == EsqlDataTypes.GEO_POINT) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.longs.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        if (leftType == EsqlDataTypes.CARTESIAN_POINT) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.longs.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        throw new EsqlIllegalArgumentException("resolved type for [" + bc + "] but didn't implement mapping");
    }

    public static EvalOperator.ExpressionEvaluator.Factory castToEvaluator(BinaryOperator<?, ?, ?, ?> op, Layout layout, DataType required, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> factory) {
        EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(op.source(), op.left().dataType(), required, EvalMapper.toEvaluator(op.left(), layout));
        EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(op.source(), op.right().dataType(), required, EvalMapper.toEvaluator(op.right(), layout));
        return (EvalOperator.ExpressionEvaluator.Factory)factory.apply((Object)op.source(), (Object)lhs, (Object)rhs);
    }
}

